/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import org.apache.asterix.common.config.AbstractProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.hyracks.util.StorageUtil;

public class MessagingProperties
extends AbstractProperties {
    public MessagingProperties(PropertiesAccessor accessor) {
        super(accessor);
    }

    public int getFrameSize() {
        return this.accessor.getInt(Option.MESSAGING_FRAME_SIZE);
    }

    public int getFrameCount() {
        return this.accessor.getInt(Option.MESSAGING_FRAME_COUNT);
    }

    public static enum Option implements IOption
    {
        MESSAGING_FRAME_SIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)4, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE), "The frame size to be used for NC to NC messaging"),
        MESSAGING_FRAME_COUNT(OptionTypes.POSITIVE_INTEGER, 512, "Number of reusable frames for NC to NC messaging");

        private final IOptionType type;
        private final Object defaultValue;
        private final String description;

        private Option(IOptionType type, Object defaultValue, String description) {
            this.type = type;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        public Section section() {
            return Section.COMMON;
        }

        public String description() {
            return this.description;
        }

        public IOptionType type() {
            return this.type;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }
    }
}

