/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.buffermanager.BufferInfo;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameFreeSlotPolicy;
import org.apache.hyracks.dataflow.std.buffermanager.IFramePool;
import org.apache.hyracks.util.IntSerDeUtils;

public class VariableFrameMemoryManager
implements IFrameBufferManager {
    private final IFramePool framePool;
    private final IFrameFreeSlotPolicy freeSlotPolicy;
    private final List<PhysicalFrameOffset> physicalFrames = new ArrayList<PhysicalFrameOffset>();
    private final List<BufferInfo> logicalFrames = new ArrayList<BufferInfo>();
    private int numPhysicalFrames = 0;
    private int numLogicalFrames = 0;

    public VariableFrameMemoryManager(IFramePool framePool, IFrameFreeSlotPolicy freeSlotPolicy) {
        this.framePool = framePool;
        this.freeSlotPolicy = freeSlotPolicy;
    }

    private int findAvailableFrame(int frameSize) throws HyracksDataException {
        int frameId = this.freeSlotPolicy.popBestFit(frameSize);
        if (frameId >= 0) {
            return frameId;
        }
        ByteBuffer buffer = this.framePool.allocateFrame(frameSize);
        if (buffer != null) {
            IntSerDeUtils.putInt((byte[])buffer.array(), (int)FrameHelper.getTupleCountOffset((int)buffer.capacity()), (int)0);
            if (this.numPhysicalFrames < this.physicalFrames.size()) {
                this.physicalFrames.get(this.numPhysicalFrames).reset(buffer, 0);
            } else {
                this.physicalFrames.add(new PhysicalFrameOffset(buffer, 0));
            }
            ++this.numPhysicalFrames;
            return this.numPhysicalFrames - 1;
        }
        return -1;
    }

    @Override
    public void reset() throws HyracksDataException {
        this.numPhysicalFrames = 0;
        this.numLogicalFrames = 0;
        this.freeSlotPolicy.reset();
        this.framePool.reset();
    }

    @Override
    public BufferInfo getFrame(int frameIndex, BufferInfo info) {
        if (frameIndex >= this.numLogicalFrames) {
            throw new IndexOutOfBoundsException();
        }
        info.reset(this.logicalFrames.get(frameIndex));
        return info;
    }

    @Override
    public int getNumFrames() {
        return this.numLogicalFrames;
    }

    @Override
    public int insertFrame(ByteBuffer frame) throws HyracksDataException {
        int frameSize = frame.capacity();
        int physicalFrameId = this.findAvailableFrame(frameSize);
        if (physicalFrameId < 0) {
            return -1;
        }
        PhysicalFrameOffset frameOffset = this.physicalFrames.get(physicalFrameId);
        ByteBuffer buffer = frameOffset.physicalFrame;
        int offset = frameOffset.physicalOffset;
        System.arraycopy(frame.array(), 0, buffer.array(), offset, frameSize);
        if (offset + frameSize < buffer.capacity()) {
            this.freeSlotPolicy.pushNewFrame(physicalFrameId, buffer.capacity() - offset - frameSize);
        }
        frameOffset.physicalOffset = offset + frameSize;
        if (this.numLogicalFrames < this.logicalFrames.size()) {
            this.logicalFrames.get(this.numLogicalFrames).reset(buffer, offset, frameSize);
        } else {
            this.logicalFrames.add(new BufferInfo(buffer, offset, frameSize));
        }
        ++this.numLogicalFrames;
        return this.numLogicalFrames - 1;
    }

    @Override
    public void close() {
        this.numPhysicalFrames = 0;
        this.numLogicalFrames = 0;
        this.physicalFrames.clear();
        this.logicalFrames.clear();
        this.freeSlotPolicy.close();
        this.framePool.close();
    }

    class PhysicalFrameOffset {
        ByteBuffer physicalFrame;
        int physicalOffset;

        PhysicalFrameOffset(ByteBuffer frame, int offset) {
            this.physicalFrame = frame;
            this.physicalOffset = offset;
        }

        void reset(ByteBuffer frame, int offset) {
            this.physicalFrame = frame;
            this.physicalOffset = offset;
        }
    }
}

