/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.util.StorageUtil;
import org.apache.logging.log4j.Level;

public class OptionTypes {
    public static final IOptionType<Integer> INTEGER_BYTE_UNIT = new IntegerByteUnit();
    public static final IOptionType<Integer> POSITIVE_INTEGER_BYTE_UNIT = new IntegerByteUnit(1, Integer.MAX_VALUE);
    public static final IOptionType<Long> LONG_BYTE_UNIT = new LongByteUnit();
    public static final IOptionType<Long> POSITIVE_LONG_BYTE_UNIT = new LongByteUnit(1L, Long.MAX_VALUE);
    public static final IOptionType<Short> SHORT = new IOptionType<Short>(){

        public Short parse(String s) {
            int value = Integer.decode(s);
            return this.validateShort(value);
        }

        private Short validateShort(int value) {
            if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
                throw new IllegalArgumentException("The given value " + value + " does not fit in a short");
            }
            return (short)value;
        }

        public Short parse(JsonNode node) {
            return node.isNull() ? null : this.validateShort(node.asInt());
        }

        public Class<Short> targetType() {
            return Short.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Short)value).shortValue());
        }
    };
    public static final IOptionType<Integer> INTEGER = new IntegerOptionType();
    public static final IOptionType<Double> DOUBLE = new IOptionType<Double>(){

        public Double parse(String s) {
            return Double.parseDouble(s);
        }

        public Double parse(JsonNode node) {
            return node.isNull() ? null : Double.valueOf(node.asDouble());
        }

        public Class<Double> targetType() {
            return Double.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Double)value).doubleValue());
        }
    };
    public static final IOptionType<String> STRING = new IOptionType<String>(){

        public String parse(String s) {
            return s;
        }

        public String parse(JsonNode node) {
            return node.isNull() ? null : node.asText();
        }

        public Class<String> targetType() {
            return String.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, (String)value);
        }
    };
    public static final IOptionType<Long> LONG = new LongOptionType();
    public static final IOptionType<Boolean> BOOLEAN = new IOptionType<Boolean>(){

        public Boolean parse(String s) {
            return Boolean.parseBoolean(s);
        }

        public Boolean parse(JsonNode node) {
            return node.isNull() ? null : Boolean.valueOf(node.asBoolean());
        }

        public Class<Boolean> targetType() {
            return Boolean.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Boolean)value).booleanValue());
        }
    };
    public static final IOptionType<Level> LEVEL = new IOptionType<Level>(){

        public Level parse(String s) {
            if (s == null) {
                throw new IllegalArgumentException("Logging level cannot be null");
            }
            Level level = Level.getLevel((String)s);
            if (level == null) {
                throw new IllegalArgumentException("Unrecognized logging level: " + s);
            }
            return level;
        }

        public Level parse(JsonNode node) {
            return node.isNull() ? null : this.parse(node.asText());
        }

        public Class<Level> targetType() {
            return Level.class;
        }

        public String serializeToJSON(Object value) {
            return value == null ? null : ((Level)value).name();
        }

        public String serializeToIni(Object value) {
            return ((Level)value).name();
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, this.serializeToJSON(value));
        }
    };
    public static final IOptionType<String[]> STRING_ARRAY = new IOptionType<String[]>(){

        public String[] parse(String s) {
            return s == null ? null : s.split("\\s*,\\s*");
        }

        public String[] parse(JsonNode node) {
            if (node.isNull()) {
                return null;
            }
            ArrayList strings = new ArrayList();
            if (node instanceof ArrayNode) {
                node.elements().forEachRemaining(n -> strings.add(n.asText()));
                return strings.toArray(new String[0]);
            }
            return this.parse(node.asText());
        }

        public Class<String[]> targetType() {
            return String[].class;
        }

        public String serializeToIni(Object value) {
            return String.join((CharSequence)",", (String[])value);
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            if (value == null) {
                node.putNull(fieldName);
            } else {
                ArrayNode array = node.putArray(fieldName);
                Stream.of((String[])value).forEachOrdered(arg_0 -> ((ArrayNode)array).add(arg_0));
            }
        }
    };
    public static final IOptionType<URL> URL = new IOptionType<URL>(){

        public URL parse(String s) {
            try {
                return s == null ? null : new URL(s);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public URL parse(JsonNode node) {
            return node.isNull() ? null : this.parse(node.asText());
        }

        public Class<URL> targetType() {
            return URL.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, value == null ? null : String.valueOf(value));
        }
    };
    public static final IOptionType<Integer> NONNEGATIVE_INTEGER = OptionTypes.getRangedIntegerType(0, Integer.MAX_VALUE);
    public static final IOptionType<Integer> POSITIVE_INTEGER = OptionTypes.getRangedIntegerType(1, Integer.MAX_VALUE);
    static final Map<IOptionType, IOptionType> COLLECTION_TYPES = Collections.singletonMap(STRING_ARRAY, STRING);

    private OptionTypes() {
    }

    public static IOptionType<Integer> getRangedIntegerType(int minValueInclusive, int maxValueInclusive) {
        return new RangedIntegerOptionType(minValueInclusive, maxValueInclusive);
    }

    private static class LongOptionType
    implements IOptionType<Long> {
        private LongOptionType() {
        }

        public Long parse(String s) {
            return Long.parseLong(s);
        }

        public Long parse(JsonNode node) {
            return node.isNull() ? null : Long.valueOf(node.asLong());
        }

        public Class<Long> targetType() {
            return Long.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Long)value).longValue());
        }
    }

    private static class LongByteUnit
    extends RangedLongOptionType {
        LongByteUnit() {
            this(Long.MIN_VALUE, Long.MAX_VALUE);
        }

        LongByteUnit(long minValue, long maxValue) {
            super(minValue, maxValue);
        }

        @Override
        public Long parse(String s) {
            if (s == null) {
                return null;
            }
            long result = StorageUtil.getByteValue((String)s);
            this.rangeCheck(result);
            return result;
        }

        @Override
        public Long parse(JsonNode node) {
            return node.isNull() ? null : this.parse(node.asText());
        }

        public String serializeToHumanReadable(Object value) {
            return value + " (" + StorageUtil.toHumanReadableSize((long)((Long)value)) + ")";
        }
    }

    private static class RangedLongOptionType
    extends LongOptionType {
        private final long minValue;
        private final long maxValue;

        RangedLongOptionType(long minValue, long maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        public Long parse(String value) {
            long longValue = super.parse(value);
            this.rangeCheck(longValue);
            return longValue;
        }

        void rangeCheck(long longValue) {
            if (longValue < this.minValue || longValue > this.maxValue) {
                if (this.maxValue == Long.MAX_VALUE) {
                    if (this.minValue == 0L) {
                        throw new IllegalArgumentException("long value must not be negative, but was " + longValue);
                    }
                    if (this.minValue == 1L) {
                        throw new IllegalArgumentException("long value must be greater than zero, but was " + longValue);
                    }
                }
                throw new IllegalArgumentException("long value must be between " + this.minValue + "-" + this.maxValue + " (inclusive)");
            }
        }
    }

    private static class IntegerByteUnit
    extends RangedIntegerOptionType {
        IntegerByteUnit() {
            this(Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        IntegerByteUnit(int minValue, int maxValue) {
            super(minValue, maxValue);
        }

        @Override
        public Integer parse(String s) {
            if (s == null) {
                return null;
            }
            long result = StorageUtil.getByteValue((String)s);
            this.rangeCheck(result);
            return (int)result;
        }

        @Override
        public Integer parse(JsonNode node) {
            return node.isNull() ? null : this.parse(node.asText());
        }

        public String serializeToHumanReadable(Object value) {
            return value + " (" + StorageUtil.toHumanReadableSize((long)((Integer)value).intValue()) + ")";
        }
    }

    private static class RangedIntegerOptionType
    extends IntegerOptionType {
        private final int minValue;
        private final int maxValue;

        RangedIntegerOptionType(int minValue, int maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        public Integer parse(String value) {
            int intValue = super.parse(value);
            this.rangeCheck(intValue);
            return intValue;
        }

        void rangeCheck(long intValue) {
            if (intValue < (long)this.minValue || intValue > (long)this.maxValue) {
                if (this.maxValue == Integer.MAX_VALUE) {
                    if (this.minValue == 0) {
                        throw new IllegalArgumentException("integer value must not be negative, but was " + intValue);
                    }
                    if (this.minValue == 1) {
                        throw new IllegalArgumentException("integer value must be greater than zero, but was " + intValue);
                    }
                }
                throw new IllegalArgumentException("integer value must be between " + this.minValue + "-" + this.maxValue + " (inclusive)");
            }
        }
    }

    public static class IntegerOptionType
    implements IOptionType<Integer> {
        public Integer parse(String s) {
            return Integer.parseInt(s);
        }

        public Integer parse(JsonNode node) {
            return node.isNull() ? null : Integer.valueOf(node.asInt());
        }

        public Class<Integer> targetType() {
            return Integer.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Integer)value).intValue());
        }
    }
}

