/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.recovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.ioopcallbacks.LSMIOOperationCallback;
import org.apache.asterix.common.transactions.CheckpointProperties;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.transaction.management.service.recovery.AbstractCheckpointManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CheckpointManager
extends AbstractCheckpointManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long NO_SECURED_LSN = -1L;
    private final long datasetCheckpointIntervalNanos;
    private final Map<TxnId, Long> securedLSNs;
    private int suspendCount = 0;

    public CheckpointManager(ITransactionSubsystem txnSubsystem, CheckpointProperties checkpointProperties) {
        super(txnSubsystem, checkpointProperties);
        this.datasetCheckpointIntervalNanos = TimeUnit.SECONDS.toNanos(checkpointProperties.getDatasetCheckpointInterval());
        this.securedLSNs = new HashMap<TxnId, Long>();
    }

    public synchronized void doSharpCheckpoint() throws HyracksDataException {
        LOGGER.info("Starting sharp checkpoint...");
        IDatasetLifecycleManager datasetLifecycleManager = this.txnSubsystem.getApplicationContext().getDatasetLifecycleManager();
        datasetLifecycleManager.flushAllDatasets();
        this.capture(-1L, true);
        this.txnSubsystem.getLogManager().renewLogFiles();
        LOGGER.info("Completed sharp checkpoint.");
    }

    public synchronized long tryCheckpoint(long checkpointTargetLSN) throws HyracksDataException {
        boolean checkpointSucceeded;
        LOGGER.info("Attemping soft checkpoint...");
        long minSecuredLSN = this.getMinSecuredLSN();
        if (minSecuredLSN != -1L && checkpointTargetLSN >= minSecuredLSN) {
            return minSecuredLSN;
        }
        long minFirstLSN = this.txnSubsystem.getRecoveryManager().getMinFirstLSN();
        boolean bl = checkpointSucceeded = minFirstLSN >= checkpointTargetLSN;
        if (!checkpointSucceeded && !this.isSuspended()) {
            IDatasetLifecycleManager dlcm = this.txnSubsystem.getApplicationContext().getDatasetLifecycleManager();
            dlcm.asyncFlushMatchingIndexes(this.newLaggingDatasetPredicate(checkpointTargetLSN));
        }
        this.capture(minFirstLSN, false);
        if (checkpointSucceeded) {
            this.txnSubsystem.getLogManager().deleteOldLogFiles(minFirstLSN);
            LOGGER.info(String.format("soft checkpoint succeeded at LSN(%s)", minFirstLSN));
        }
        return minFirstLSN;
    }

    public synchronized void secure(TxnId id) throws HyracksDataException {
        this.securedLSNs.put(id, this.txnSubsystem.getRecoveryManager().getMinFirstLSN());
    }

    public synchronized void completed(TxnId id) {
        this.securedLSNs.remove(id);
    }

    public synchronized void checkpointIdleDatasets() throws HyracksDataException {
        if (this.isSuspended()) {
            return;
        }
        IDatasetLifecycleManager dlcm = this.txnSubsystem.getApplicationContext().getDatasetLifecycleManager();
        dlcm.asyncFlushMatchingIndexes(this.newIdleDatasetPredicate());
    }

    private synchronized boolean isSuspended() {
        return this.suspendCount != 0;
    }

    public synchronized void suspend() {
        ++this.suspendCount;
    }

    public synchronized void resume() {
        --this.suspendCount;
    }

    private synchronized long getMinSecuredLSN() {
        return this.securedLSNs.isEmpty() ? -1L : Collections.min(this.securedLSNs.values());
    }

    private Predicate<ILSMIndex> newIdleDatasetPredicate() {
        long currentTime = System.nanoTime();
        return lsmIndex -> {
            if (lsmIndex.isPrimaryIndex()) {
                PrimaryIndexOperationTracker opTracker = (PrimaryIndexOperationTracker)lsmIndex.getOperationTracker();
                return currentTime - opTracker.getLastFlushTime() >= this.datasetCheckpointIntervalNanos;
            }
            return false;
        };
    }

    private Predicate<ILSMIndex> newLaggingDatasetPredicate(long checkpointTargetLSN) {
        return lsmIndex -> {
            LSMIOOperationCallback ioCallback = (LSMIOOperationCallback)lsmIndex.getIOOperationCallback();
            return ioCallback.getPersistenceLsn() < checkpointTargetLSN;
        };
    }
}

