/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.util;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.am.common.util.TreeIndexStats;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class TreeIndexStatsGatherer {
    private final TreeIndexStats treeIndexStats = new TreeIndexStats();
    private final IBufferCache bufferCache;
    private final IPageManager freePageManager;
    private final FileReference fileRef;
    private final int rootPage;

    public TreeIndexStatsGatherer(IBufferCache bufferCache, IPageManager freePageManager, FileReference fileRef, int rootPage) {
        this.bufferCache = bufferCache;
        this.freePageManager = freePageManager;
        this.fileRef = fileRef;
        this.rootPage = rootPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeIndexStats gatherStats(ITreeIndexFrame leafFrame, ITreeIndexFrame interiorFrame, ITreeIndexMetadataFrame metaFrame) throws HyracksDataException {
        int fileId = this.bufferCache.openFile(this.fileRef);
        this.treeIndexStats.begin();
        int maxPageId = this.freePageManager.getMaxPageId(metaFrame);
        for (int pageId = 0; pageId <= maxPageId; ++pageId) {
            ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)fileId, (int)pageId), false);
            page.acquireReadLatch();
            try {
                metaFrame.setPage(page);
                leafFrame.setPage(page);
                interiorFrame.setPage(page);
                if (leafFrame.isLeaf()) {
                    if (pageId == this.rootPage) {
                        this.treeIndexStats.addRoot(leafFrame);
                        continue;
                    }
                    this.treeIndexStats.add(leafFrame);
                    continue;
                }
                if (interiorFrame.isInterior()) {
                    if (pageId == this.rootPage) {
                        this.treeIndexStats.addRoot(interiorFrame);
                        continue;
                    }
                    this.treeIndexStats.add(interiorFrame);
                    continue;
                }
                this.treeIndexStats.add(metaFrame);
                continue;
            }
            finally {
                page.releaseReadLatch();
                this.bufferCache.unpin(page);
            }
        }
        this.treeIndexStats.end();
        this.bufferCache.closeFile(fileId);
        return this.treeIndexStats;
    }
}

