/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import java.io.IOException;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADAuthenticator;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshTokenBasedTokenProvider
extends AccessTokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenProvider.class);
    private final String authEndpoint;
    private final String clientId;
    private final String refreshToken;

    public RefreshTokenBasedTokenProvider(String authEndpoint, String clientId, String refreshToken) {
        Preconditions.checkNotNull((Object)authEndpoint, (Object)"authEndpoint");
        Preconditions.checkNotNull((Object)clientId, (Object)"clientId");
        Preconditions.checkNotNull((Object)refreshToken, (Object)"refreshToken");
        this.authEndpoint = authEndpoint;
        this.clientId = clientId;
        this.refreshToken = refreshToken;
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        LOG.debug("AADToken: refreshing refresh-token based token");
        return AzureADAuthenticator.getTokenUsingRefreshToken(this.authEndpoint, this.clientId, this.refreshToken);
    }
}

