/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.typecomputer.impl.AggregateResultTypeComputer;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ScalarVersionOfAggregateResultType
extends AbstractResultTypeComputer {
    private final AggregateResultTypeComputer aggResultTypeComputer;

    public ScalarVersionOfAggregateResultType(AggregateResultTypeComputer aggResultTypeComputer) {
        this.aggResultTypeComputer = aggResultTypeComputer;
    }

    @Override
    protected void checkArgType(FunctionIdentifier funcId, int argIndex, IAType argType, SourceLocation sourceLoc) throws AlgebricksException {
        if (argIndex == 0) {
            switch (argType.getTypeTag()) {
                case ARRAY: 
                case MULTISET: {
                    AbstractCollectionType act = (AbstractCollectionType)argType;
                    this.aggResultTypeComputer.checkArgType(funcId, argIndex, act.getItemType(), sourceLoc);
                }
            }
        }
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        IAType argType = strippedInputTypes[0];
        switch (argType.getTypeTag()) {
            case ARRAY: 
            case MULTISET: {
                AbstractCollectionType act = (AbstractCollectionType)argType;
                IAType[] strippedInputTypes2 = (IAType[])strippedInputTypes.clone();
                strippedInputTypes2[0] = act.getItemType();
                IAType resultType = this.aggResultTypeComputer.getResultType(expr, strippedInputTypes2);
                switch (resultType.getTypeTag()) {
                    case NULL: 
                    case MISSING: 
                    case ANY: {
                        return resultType;
                    }
                    case UNION: {
                        return AUnionType.createUnknownableType(((AUnionType)resultType).getActualType());
                    }
                }
                return AUnionType.createUnknownableType(resultType);
            }
        }
        return BuiltinType.ANY;
    }
}

