/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationTokenIOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
public final class MarshalledCredentials
implements Writable,
Serializable {
    @VisibleForTesting
    public static final String INVALID_CREDENTIALS = "Invalid AWS credentials";
    private static final int MAX_SECRET_LENGTH = 8192;
    private static final long serialVersionUID = 8444610385533920692L;
    private String accessKey = "";
    private String secretKey = "";
    private String sessionToken = "";
    private String roleARN = "";
    private long expiration;

    public MarshalledCredentials() {
    }

    public MarshalledCredentials(String accessKey, String secretKey, String sessionToken) {
        this();
        this.accessKey = Objects.requireNonNull(accessKey);
        this.secretKey = Objects.requireNonNull(secretKey);
        this.sessionToken = sessionToken == null ? "" : sessionToken;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public Optional<OffsetDateTime> getExpirationDateTime() {
        return this.expiration == 0L ? Optional.empty() : Optional.of(OffsetDateTime.ofInstant(new Date(this.expiration).toInstant(), ZoneOffset.UTC));
    }

    public String getRoleARN() {
        return this.roleARN;
    }

    public void setRoleARN(String roleARN) {
        this.roleARN = Objects.requireNonNull(roleARN);
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = Objects.requireNonNull(accessKey, "access key");
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = Objects.requireNonNull(secretKey, "secret key");
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = Objects.requireNonNull(sessionToken, "session token");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarshalledCredentials that = (MarshalledCredentials)o;
        return this.expiration == that.expiration && Objects.equals(this.accessKey, that.accessKey) && Objects.equals(this.secretKey, that.secretKey) && Objects.equals(this.sessionToken, that.sessionToken) && Objects.equals(this.roleARN, that.roleARN);
    }

    public int hashCode() {
        return Objects.hash(this.accessKey, this.secretKey, this.sessionToken, this.roleARN, this.expiration);
    }

    public String toString() {
        String validity;
        if (this.isEmpty()) {
            return "Empty credentials";
        }
        String string = validity = this.isValid(CredentialTypeRequired.AnyNonEmpty) ? "valid" : "invalid";
        if (!this.hasSessionToken()) {
            return "full credentials (" + validity + ")";
        }
        return String.format("session credentials, expiry %s; %s(%s)", this.getExpirationDateTime().map(x -> x.format(DateTimeFormatter.ISO_DATE_TIME)).orElse("unknown"), StringUtils.isNotEmpty((CharSequence)this.roleARN) ? "role \"" + this.roleARN + "\" " : "", validity);
    }

    public boolean isEmpty() {
        return !StringUtils.isNotEmpty((CharSequence)this.accessKey) || !StringUtils.isNotEmpty((CharSequence)this.secretKey);
    }

    public boolean isValid(CredentialTypeRequired required) {
        if (this.accessKey == null || this.secretKey == null || this.sessionToken == null) {
            return false;
        }
        boolean hasAccessAndSecretKeys = StringUtils.isNotEmpty((CharSequence)this.accessKey) && StringUtils.isNotEmpty((CharSequence)this.secretKey);
        boolean hasSessionToken = this.hasSessionToken();
        switch (required) {
            case AnyIncludingEmpty: {
                return true;
            }
            case Empty: {
                return !hasAccessAndSecretKeys;
            }
            case AnyNonEmpty: {
                return hasAccessAndSecretKeys;
            }
            case FullOnly: {
                return hasAccessAndSecretKeys && !hasSessionToken;
            }
            case SessionOnly: {
                return hasAccessAndSecretKeys && this.hasSessionToken();
            }
        }
        return false;
    }

    public boolean hasSessionToken() {
        return StringUtils.isNotEmpty((CharSequence)this.sessionToken);
    }

    public void write(DataOutput out) throws IOException {
        this.validate("Writing " + this + ": ", CredentialTypeRequired.AnyIncludingEmpty);
        Text.writeString((DataOutput)out, (String)this.accessKey);
        Text.writeString((DataOutput)out, (String)this.secretKey);
        Text.writeString((DataOutput)out, (String)this.sessionToken);
        Text.writeString((DataOutput)out, (String)this.roleARN);
        out.writeLong(this.expiration);
    }

    public void readFields(DataInput in) throws IOException {
        this.accessKey = Text.readString((DataInput)in, (int)8192);
        this.secretKey = Text.readString((DataInput)in, (int)8192);
        this.sessionToken = Text.readString((DataInput)in, (int)8192);
        this.roleARN = Text.readString((DataInput)in, (int)8192);
        this.expiration = in.readLong();
    }

    public void validate(String message, CredentialTypeRequired typeRequired) throws IOException {
        if (!this.isValid(typeRequired)) {
            throw new DelegationTokenIOException(message + this.buildInvalidCredentialsError(typeRequired));
        }
    }

    public String buildInvalidCredentialsError(CredentialTypeRequired typeRequired) {
        if (this.isEmpty()) {
            return " No AWS credentials";
        }
        return " Invalid AWS credentials in " + this.toString() + " required: " + (Object)((Object)typeRequired);
    }

    public void setSecretsInConfiguration(Configuration config) {
        config.set("fs.s3a.access.key", this.accessKey);
        config.set("fs.s3a.secret.key", this.secretKey);
        S3AUtils.setIfDefined(config, "fs.s3a.session.token", this.sessionToken, "session credentials");
    }

    public static MarshalledCredentials empty() {
        return new MarshalledCredentials("", "", "");
    }

    public static enum CredentialTypeRequired {
        Empty("None"),
        AnyIncludingEmpty("Full, Session or None"),
        AnyNonEmpty("Full or Session"),
        SessionOnly("Session"),
        FullOnly("Full");

        private final String text;

        private CredentialTypeRequired(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return this.getText();
        }
    }
}

