/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.visitor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.optimizer.rules.pushdown.schema.AbstractComplexExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.AnyExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ArrayExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaNodeType;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNodeVisitor;
import org.apache.asterix.optimizer.rules.pushdown.schema.ObjectExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.RootExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.UnionExpectedSchemaNode;

public class ExpectedSchemaMergerVisitor
implements IExpectedSchemaNodeVisitor<IExpectedSchemaNode, IExpectedSchemaNode> {
    private AbstractComplexExpectedSchemaNode currentParent;

    public RootExpectedSchemaNode merge(RootExpectedSchemaNode left, RootExpectedSchemaNode right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return this.visit(left, (IExpectedSchemaNode)right);
    }

    @Override
    public RootExpectedSchemaNode visit(RootExpectedSchemaNode node, IExpectedSchemaNode arg) {
        if (!(arg instanceof RootExpectedSchemaNode)) {
            throw new IllegalStateException("Cannot merge root with non-root node");
        }
        RootExpectedSchemaNode argRoot = (RootExpectedSchemaNode)arg;
        if (node.isAllFields() || argRoot.isAllFields()) {
            return RootExpectedSchemaNode.ALL_FIELDS_ROOT_IRREPLACEABLE_NODE;
        }
        if (argRoot.isEmpty()) {
            return node;
        }
        if (node.isEmpty()) {
            return argRoot;
        }
        RootExpectedSchemaNode mergedRoot = (RootExpectedSchemaNode)RootExpectedSchemaNode.ALL_FIELDS_ROOT_NODE.replaceIfNeeded(ExpectedSchemaNodeType.OBJECT, node.getSourceLocation(), node.getFunctionName());
        this.mergeObjectFields(mergedRoot, node.getChildren(), argRoot.getChildren());
        return mergedRoot;
    }

    @Override
    public IExpectedSchemaNode visit(ObjectExpectedSchemaNode node, IExpectedSchemaNode arg) {
        ObjectExpectedSchemaNode mergedObject = new ObjectExpectedSchemaNode(this.currentParent, node.getSourceLocation(), node.getFunctionName());
        Map<String, IExpectedSchemaNode> argChildren = Collections.emptyMap();
        if (arg != null) {
            ObjectExpectedSchemaNode argObject = (ObjectExpectedSchemaNode)arg;
            argChildren = argObject.getChildren();
        }
        this.mergeObjectFields(mergedObject, node.getChildren(), argChildren);
        return mergedObject;
    }

    @Override
    public IExpectedSchemaNode visit(ArrayExpectedSchemaNode node, IExpectedSchemaNode arg) {
        IExpectedSchemaNode nodeItem = node.getChild();
        IExpectedSchemaNode argItem = null;
        if (arg != null) {
            ArrayExpectedSchemaNode arrayArg = (ArrayExpectedSchemaNode)arg;
            argItem = arrayArg.getChild();
        }
        ArrayExpectedSchemaNode mergedArray = new ArrayExpectedSchemaNode(this.currentParent, node.getSourceLocation(), node.getFunctionName());
        AbstractComplexExpectedSchemaNode previousParent = this.currentParent;
        this.currentParent = mergedArray;
        IExpectedSchemaNode mergedItem = this.merge(nodeItem, argItem);
        mergedArray.addChild(mergedItem);
        this.currentParent = previousParent;
        return mergedArray;
    }

    @Override
    public IExpectedSchemaNode visit(UnionExpectedSchemaNode node, IExpectedSchemaNode arg) {
        UnionExpectedSchemaNode union = new UnionExpectedSchemaNode(this.currentParent, node.getSourceLocation(), node.getFunctionName());
        AbstractComplexExpectedSchemaNode previousParent = this.currentParent;
        this.currentParent = union;
        if (arg == null) {
            for (Map.Entry<ExpectedSchemaNodeType, AbstractComplexExpectedSchemaNode> nodeChild : node.getChildren()) {
                IExpectedSchemaNode mergedChild = this.merge(nodeChild.getValue(), null);
                union.addChild((AbstractComplexExpectedSchemaNode)mergedChild);
            }
        } else if (arg.getType() == ExpectedSchemaNodeType.UNION) {
            UnionExpectedSchemaNode argUnion = (UnionExpectedSchemaNode)arg;
            for (Map.Entry<ExpectedSchemaNodeType, AbstractComplexExpectedSchemaNode> nodeChild : node.getChildren()) {
                IExpectedSchemaNode child = nodeChild.getValue();
                AbstractComplexExpectedSchemaNode argChild = argUnion.getChild(child.getType());
                IExpectedSchemaNode mergedChild = this.merge(child, argChild);
                union.addChild((AbstractComplexExpectedSchemaNode)mergedChild);
            }
        } else {
            for (Map.Entry<ExpectedSchemaNodeType, AbstractComplexExpectedSchemaNode> nodeChild : node.getChildren()) {
                IExpectedSchemaNode child = nodeChild.getValue();
                IExpectedSchemaNode argNode = child.getType() == arg.getType() ? arg : null;
                IExpectedSchemaNode mergedChild = this.merge(child, argNode);
                union.addChild((AbstractComplexExpectedSchemaNode)mergedChild);
            }
        }
        this.currentParent = previousParent;
        return union;
    }

    @Override
    public IExpectedSchemaNode visit(AnyExpectedSchemaNode node, IExpectedSchemaNode arg) {
        return new AnyExpectedSchemaNode(this.currentParent, node.getSourceLocation(), node.getFunctionName());
    }

    private void mergeObjectFields(ObjectExpectedSchemaNode objectNode, Map<String, IExpectedSchemaNode> left, Map<String, IExpectedSchemaNode> right) {
        AbstractComplexExpectedSchemaNode previousParent = this.currentParent;
        this.currentParent = objectNode;
        HashSet<String> mergedFields = new HashSet<String>();
        this.mergeObjectFields(objectNode, left, right, mergedFields);
        this.mergeObjectFields(objectNode, right, left, mergedFields);
        this.currentParent = previousParent;
    }

    private void mergeObjectFields(ObjectExpectedSchemaNode objectNode, Map<String, IExpectedSchemaNode> left, Map<String, IExpectedSchemaNode> right, Set<String> mergedFields) {
        for (Map.Entry<String, IExpectedSchemaNode> leftChild : left.entrySet()) {
            String fieldName = leftChild.getKey();
            if (mergedFields.contains(fieldName)) continue;
            IExpectedSchemaNode rightChild = right.get(fieldName);
            IExpectedSchemaNode mergedChild = this.merge(leftChild.getValue(), rightChild);
            objectNode.addChild(fieldName, mergedChild);
            mergedFields.add(fieldName);
        }
    }

    private IExpectedSchemaNode merge(IExpectedSchemaNode leftChild, IExpectedSchemaNode rightChild) {
        if (rightChild == null || leftChild.getType() == ExpectedSchemaNodeType.ANY || leftChild.getType() == ExpectedSchemaNodeType.UNION) {
            return leftChild.accept(this, rightChild);
        }
        if (rightChild.getType() == ExpectedSchemaNodeType.ANY || rightChild.getType() == ExpectedSchemaNodeType.UNION) {
            return rightChild.accept(this, leftChild);
        }
        if (leftChild.getType() != rightChild.getType()) {
            return this.createUnionNode(leftChild, rightChild);
        }
        return leftChild.accept(this, rightChild);
    }

    private IExpectedSchemaNode createUnionNode(IExpectedSchemaNode leftChild, IExpectedSchemaNode rightChild) {
        UnionExpectedSchemaNode union = new UnionExpectedSchemaNode(this.currentParent, leftChild.getSourceLocation(), leftChild.getFunctionName());
        AbstractComplexExpectedSchemaNode previousParent = this.currentParent;
        this.currentParent = union;
        IExpectedSchemaNode leftNewChild = leftChild.accept(this, null);
        IExpectedSchemaNode rightNewChild = rightChild.accept(this, null);
        union.addChild((AbstractComplexExpectedSchemaNode)leftNewChild);
        union.addChild((AbstractComplexExpectedSchemaNode)rightNewChild);
        this.currentParent = previousParent;
        return union;
    }
}

