/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.annotations.ExistsComparisonExpressionAnnotation;
import org.apache.asterix.metadata.utils.PushdownUtil;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.rules.pushdown.PushdownContext;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.DefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.UseDescriptor;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;

public class FilterExpressionInlineVisitor
implements ILogicalExpressionVisitor<ILogicalExpression, Map<ILogicalOperator, List<UseDescriptor>>> {
    private final PushdownContext pushdownContext;
    private final IOptimizationContext context;
    private final Map<ILogicalOperator, ILogicalExpression> inlinedCache;

    public FilterExpressionInlineVisitor(PushdownContext pushdownContext, IOptimizationContext context) {
        this.pushdownContext = pushdownContext;
        this.context = context;
        this.inlinedCache = new HashMap<ILogicalOperator, ILogicalExpression>();
    }

    public ILogicalExpression cloneAndInline(UseDescriptor useDescriptor, Map<ILogicalOperator, List<UseDescriptor>> subplanSelects) throws AlgebricksException {
        ILogicalOperator op = useDescriptor.getOperator();
        ILogicalExpression inlinedExpr = this.inlinedCache.get(op);
        if (inlinedExpr == null) {
            inlinedExpr = (ILogicalExpression)useDescriptor.getExpression().accept((ILogicalExpressionVisitor)this, subplanSelects);
            this.inlinedCache.put(op, inlinedExpr);
        }
        return inlinedExpr.cloneExpression();
    }

    public ILogicalExpression visitConstantExpression(ConstantExpression expr, Map<ILogicalOperator, List<UseDescriptor>> subplanSelects) throws AlgebricksException {
        return expr;
    }

    public ILogicalExpression visitVariableReferenceExpression(VariableReferenceExpression expr, Map<ILogicalOperator, List<UseDescriptor>> subplanSelects) throws AlgebricksException {
        LogicalVariable variable = expr.getVariableReference();
        DefineDescriptor defineDescriptor = this.pushdownContext.getDefineDescriptor(variable);
        if (defineDescriptor == null || defineDescriptor.isScanDefinition()) {
            return expr.cloneExpression();
        }
        ILogicalOperator subplanOp = defineDescriptor.getSubplanOperator();
        ILogicalExpression defExpr = defineDescriptor.getExpression();
        if (subplanOp != null && subplanSelects.containsKey(subplanOp) && PushdownUtil.isSupportedFilterAggregateFunction((ILogicalExpression)defExpr)) {
            List<UseDescriptor> selects = subplanSelects.get(subplanOp);
            return this.visitSubplanSelects(selects, subplanSelects);
        }
        return (ILogicalExpression)defineDescriptor.getExpression().accept((ILogicalExpressionVisitor)this, subplanSelects);
    }

    public ILogicalExpression visitAggregateFunctionCallExpression(AggregateFunctionCallExpression expr, Map<ILogicalOperator, List<UseDescriptor>> subplanSelects) throws AlgebricksException {
        return this.cloneAndInlineFunction((AbstractFunctionCallExpression)expr, subplanSelects);
    }

    public ILogicalExpression visitScalarFunctionCallExpression(ScalarFunctionCallExpression expr, Map<ILogicalOperator, List<UseDescriptor>> subplanSelects) throws AlgebricksException {
        ILogicalExpression inlinable = this.getInlinableExpression(expr);
        if (inlinable.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            return (ILogicalExpression)inlinable.accept((ILogicalExpressionVisitor)this, subplanSelects);
        }
        return this.cloneAndInlineFunction((AbstractFunctionCallExpression)expr, subplanSelects);
    }

    public ILogicalExpression visitStatefulFunctionCallExpression(StatefulFunctionCallExpression expr, Map<ILogicalOperator, List<UseDescriptor>> subplanSelects) throws AlgebricksException {
        return this.cloneAndInlineFunction((AbstractFunctionCallExpression)expr, subplanSelects);
    }

    public ILogicalExpression visitUnnestingFunctionCallExpression(UnnestingFunctionCallExpression expr, Map<ILogicalOperator, List<UseDescriptor>> subplanSelects) throws AlgebricksException {
        return this.cloneAndInlineFunction((AbstractFunctionCallExpression)expr, subplanSelects);
    }

    private ILogicalExpression cloneAndInlineFunction(AbstractFunctionCallExpression funcExpr, Map<ILogicalOperator, List<UseDescriptor>> subplanSelects) throws AlgebricksException {
        AbstractFunctionCallExpression cloned = (AbstractFunctionCallExpression)funcExpr.cloneExpression();
        for (Mutable arg : cloned.getArguments()) {
            arg.setValue((Object)((ILogicalExpression)((ILogicalExpression)arg.getValue()).accept((ILogicalExpressionVisitor)this, subplanSelects)));
        }
        return FilterExpressionInlineVisitor.convertToOr(cloned, this.context);
    }

    private ILogicalExpression getInlinableExpression(ScalarFunctionCallExpression expression) {
        ScalarFunctionCallExpression funcExpr = expression.cloneExpression();
        IExpressionAnnotation existsAnnotation = funcExpr.getAnnotation(ExistsComparisonExpressionAnnotation.class);
        if (existsAnnotation != null) {
            for (Mutable argRef : funcExpr.getArguments()) {
                ILogicalExpression arg = (ILogicalExpression)argRef.getValue();
                if (arg.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
                return arg;
            }
        }
        return funcExpr;
    }

    private boolean notContainsZeroConstant(AbstractFunctionCallExpression funcExpr) {
        for (Mutable arg : funcExpr.getArguments()) {
            Long argValue = ConstantExpressionUtil.getLongConstant((ILogicalExpression)((ILogicalExpression)arg.getValue()));
            if (argValue == null || argValue != 0L) continue;
            return false;
        }
        return true;
    }

    private static ILogicalExpression convertToOr(AbstractFunctionCallExpression expression, IOptimizationContext context) {
        if (!BuiltinFunctions.EQ.equals((Object)expression.getFunctionIdentifier())) {
            return expression;
        }
        ILogicalExpression left = (ILogicalExpression)((Mutable)expression.getArguments().get(0)).getValue();
        ILogicalExpression right = (ILogicalExpression)((Mutable)expression.getArguments().get(1)).getValue();
        ILogicalExpression valueExpr = left;
        AOrderedList constArray = PushdownUtil.getArrayConstantFromScanCollection((ILogicalExpression)right);
        if (constArray == null) {
            valueExpr = right;
            constArray = PushdownUtil.getArrayConstantFromScanCollection((ILogicalExpression)left);
        }
        if (constArray == null) {
            return expression;
        }
        IFunctionInfo orInfo = context.getMetadataProvider().lookupFunction(AlgebricksBuiltinFunctions.OR);
        ArrayList<MutableObject> orArgs = new ArrayList<MutableObject>();
        ScalarFunctionCallExpression orExpr = new ScalarFunctionCallExpression(orInfo, orArgs);
        IFunctionInfo eqInfo = context.getMetadataProvider().lookupFunction(AlgebricksBuiltinFunctions.EQ);
        for (int i = 0; i < constArray.size(); ++i) {
            ArrayList<MutableObject> eqArgs = new ArrayList<MutableObject>(2);
            eqArgs.add(new MutableObject((Object)valueExpr));
            eqArgs.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(constArray.getItem(i)))));
            orArgs.add(new MutableObject((Object)new ScalarFunctionCallExpression(eqInfo, eqArgs)));
        }
        return orExpr;
    }

    private ILogicalExpression visitSubplanSelects(List<UseDescriptor> useDescriptors, Map<ILogicalOperator, List<UseDescriptor>> subplanSelects) throws AlgebricksException {
        if (useDescriptors.size() == 1) {
            return (ILogicalExpression)useDescriptors.get(0).getExpression().accept((ILogicalExpressionVisitor)this, subplanSelects);
        }
        ArrayList<MutableObject> andArgs = new ArrayList<MutableObject>();
        for (UseDescriptor useDescriptor : useDescriptors) {
            ILogicalExpression inlined = (ILogicalExpression)useDescriptor.getExpression().accept((ILogicalExpressionVisitor)this, subplanSelects);
            andArgs.add(new MutableObject((Object)inlined));
        }
        IFunctionInfo fInfo = this.context.getMetadataProvider().lookupFunction(BuiltinFunctions.AND);
        return new ScalarFunctionCallExpression(fInfo, andArgs);
    }

    private static FunctionIdentifier[] createExistsPattern() {
        FunctionIdentifier[] pattern = new FunctionIdentifier[]{BuiltinFunctions.NEQ, BuiltinFunctions.COUNT};
        return pattern;
    }
}

