/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.metadata.schema.primitive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.column.metadata.PathInfoSerializer;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.ISchemaNodeVisitor;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class PrimitiveSchemaNode
extends AbstractSchemaNode {
    private final int columnIndex;
    private final ATypeTag typeTag;
    private final boolean primaryKey;

    public PrimitiveSchemaNode(int columnIndex, ATypeTag typeTag, boolean primaryKey) {
        this.columnIndex = columnIndex;
        this.typeTag = typeTag;
        this.primaryKey = primaryKey;
    }

    public PrimitiveSchemaNode(ATypeTag typeTag, DataInput input) throws IOException {
        this.typeTag = typeTag;
        this.columnIndex = input.readInt();
        this.primaryKey = input.readBoolean();
    }

    public final int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public final ATypeTag getTypeTag() {
        return this.typeTag;
    }

    @Override
    public final boolean isNested() {
        return false;
    }

    @Override
    public final boolean isObjectOrCollection() {
        return false;
    }

    @Override
    public final boolean isCollection() {
        return false;
    }

    public final boolean isPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public final <R, T> R accept(ISchemaNodeVisitor<R, T> visitor, T arg) throws HyracksDataException {
        return visitor.visit(this, arg);
    }

    @Override
    public void serialize(DataOutput output, PathInfoSerializer pathInfoSerializer) throws IOException {
        output.write(this.typeTag.serialize());
        output.writeInt(this.columnIndex);
        output.writeBoolean(this.primaryKey);
        pathInfoSerializer.writePathInfo(this.typeTag, this.columnIndex, this.primaryKey);
    }
}

