/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.idl;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.compiler.idl.SchemaResolver;
import org.apache.avro.compiler.schema.SchemaVisitor;
import org.apache.avro.compiler.schema.SchemaVisitorAction;
import org.apache.avro.compiler.schema.Schemas;

public final class ResolvingVisitor
implements SchemaVisitor<Schema> {
    private final IdentityHashMap<Schema, Schema> replace;
    private final Function<String, Schema> symbolTable;
    private final Schema root;

    public ResolvingVisitor(Schema root, IdentityHashMap<Schema, Schema> replace, Function<String, Schema> symbolTable) {
        this.replace = replace;
        this.symbolTable = symbolTable;
        this.root = root;
    }

    @Override
    public SchemaVisitorAction visitTerminal(Schema terminal) {
        Schema newSchema;
        Schema.Type type = terminal.getType();
        switch (type) {
            case RECORD: 
            case ARRAY: 
            case MAP: 
            case UNION: {
                if (!this.replace.containsKey(terminal)) {
                    throw new IllegalStateException("Schema " + String.valueOf(terminal) + " must be already processed");
                }
                return SchemaVisitorAction.CONTINUE;
            }
            case BOOLEAN: 
            case BYTES: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NULL: 
            case STRING: {
                newSchema = Schema.create(type);
                break;
            }
            case ENUM: {
                newSchema = Schema.createEnum(terminal.getName(), terminal.getDoc(), terminal.getNamespace(), terminal.getEnumSymbols(), terminal.getEnumDefault());
                break;
            }
            case FIXED: {
                newSchema = Schema.createFixed(terminal.getName(), terminal.getDoc(), terminal.getNamespace(), terminal.getFixedSize());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported schema " + String.valueOf(terminal));
            }
        }
        ResolvingVisitor.copyAllProperties(terminal, newSchema);
        this.replace.put(terminal, newSchema);
        return SchemaVisitorAction.CONTINUE;
    }

    public static void copyAllProperties(Schema first, Schema second) {
        Schemas.copyLogicalTypes(first, second);
        Schemas.copyAliases(first, second);
        Schemas.copyProperties(first, second);
    }

    public static void copyAllProperties(Schema.Field first, Schema.Field second) {
        Schemas.copyAliases(first, second);
        Schemas.copyProperties(first, second);
    }

    @Override
    public SchemaVisitorAction visitNonTerminal(Schema nt) {
        Schema.Type type = nt.getType();
        if (type == Schema.Type.RECORD) {
            if (SchemaResolver.isUnresolvedSchema(nt)) {
                String unresolvedSchemaName = SchemaResolver.getUnresolvedSchemaName(nt);
                Schema resSchema = this.symbolTable.apply(unresolvedSchemaName);
                if (resSchema == null) {
                    throw new AvroTypeException("Unable to resolve " + unresolvedSchemaName);
                }
                Schema replacement = this.replace.get(resSchema);
                if (replacement == null) {
                    this.replace.put(nt, Schemas.visit(resSchema, new ResolvingVisitor(resSchema, new IdentityHashMap<Schema, Schema>(), this.symbolTable)));
                } else {
                    this.replace.put(nt, replacement);
                }
            } else {
                Schema newSchema = Schema.createRecord(nt.getName(), nt.getDoc(), nt.getNamespace(), nt.isError());
                ResolvingVisitor.copyAllProperties(nt, newSchema);
                this.replace.put(nt, newSchema);
            }
        }
        return SchemaVisitorAction.CONTINUE;
    }

    @Override
    public SchemaVisitorAction afterVisitNonTerminal(Schema nt) {
        Schema newSchema;
        Schema.Type type = nt.getType();
        switch (type) {
            case RECORD: {
                if (!SchemaResolver.isUnresolvedSchema(nt)) {
                    Schema newSchema2 = this.replace.get(nt);
                    List<Schema.Field> fields = nt.getFields();
                    ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>(fields.size());
                    for (Schema.Field field : fields) {
                        newFields.add(new Schema.Field(field, this.replace.get(field.schema())));
                    }
                    newSchema2.setFields(newFields);
                }
                return SchemaVisitorAction.CONTINUE;
            }
            case UNION: {
                List<Schema> types = nt.getTypes();
                ArrayList<Schema> newTypes = new ArrayList<Schema>(types.size());
                for (Schema sch : types) {
                    newTypes.add(this.replace.get(sch));
                }
                newSchema = Schema.createUnion(newTypes);
                break;
            }
            case ARRAY: {
                newSchema = Schema.createArray(this.replace.get(nt.getElementType()));
                break;
            }
            case MAP: {
                newSchema = Schema.createMap(this.replace.get(nt.getValueType()));
                break;
            }
            default: {
                throw new IllegalStateException("Illegal type " + String.valueOf((Object)type) + ", schema " + String.valueOf(nt));
            }
        }
        ResolvingVisitor.copyAllProperties(nt, newSchema);
        this.replace.put(nt, newSchema);
        return SchemaVisitorAction.CONTINUE;
    }

    @Override
    public Schema get() {
        return this.replace.get(this.root);
    }

    public String toString() {
        return "ResolvingVisitor{replace=" + String.valueOf(this.replace) + ", symbolTable=" + String.valueOf(this.symbolTable) + ", root=" + String.valueOf(this.root) + "}";
    }
}

