/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.idl.Idl;
import org.apache.avro.idl.IdlFile;
import org.apache.avro.idl.IdlReader;
import org.apache.avro.tool.Tool;

public class IdlTool
implements Tool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        Protocol p;
        Object parser;
        boolean useJavaCC = "--useJavaCC".equals(this.getArg(args, 0, null));
        if (args.size() > (useJavaCC ? 3 : 2) || args.size() == 1 && (args.get(0).equals("--help") || args.get(0).equals("-help"))) {
            err.println("Usage: idl [--useJavaCC] [in [out]]");
            err.println();
            err.println("If an output path is not specified, outputs to stdout.");
            err.println("If no input or output is specified, takes input from");
            err.println("stdin and outputs to stdout.");
            err.println("The special path \"-\" may also be specified to refer to");
            err.println("stdin and stdout.");
            return -1;
        }
        String inputName = this.getArg(args, useJavaCC ? 1 : 0, "-");
        File inputFile = "-".equals(inputName) ? null : new File(inputName);
        String outputName = this.getArg(args, useJavaCC ? 2 : 1, "-");
        File outputFile = "-".equals(outputName) ? null : new File(outputName);
        Schema m3 = null;
        if (useJavaCC) {
            parser = new Idl(inputFile);
            try {
                p = ((Idl)parser).CompilationUnit();
                for (String warning : ((Idl)parser).getWarningsAfterParsing()) {
                    err.println("Warning: " + warning);
                }
            }
            finally {
                ((Idl)parser).close();
            }
        } else {
            parser = new IdlReader();
            IdlFile idlFile = inputFile == null ? ((IdlReader)parser).parse(in) : ((IdlReader)parser).parse(inputFile.toPath());
            for (String warning : idlFile.getWarnings()) {
                err.println("Warning: " + warning);
            }
            p = idlFile.getProtocol();
            m3 = idlFile.getMainSchema();
        }
        PrintStream parseOut = out;
        if (outputFile != null) {
            parseOut = new PrintStream(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]));
        }
        if (m3 == null && p == null) {
            err.println("Error: the IDL file does not contain a schema nor a protocol.");
            return 1;
        }
        try {
            parseOut.print(m3 == null ? p.toString(true) : m3.toString(true));
        }
        finally {
            if (parseOut != out) {
                parseOut.close();
            }
        }
        return 0;
    }

    private String getArg(List<String> args, int index, String defaultValue) {
        if (index < args.size()) {
            return args.get(index);
        }
        return defaultValue;
    }

    @Override
    public String getName() {
        return "idl";
    }

    @Override
    public String getShortDescription() {
        return "Generates a JSON schema or protocol from an Avro IDL file";
    }
}

