/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.twitter.common.zookeeper.ServerSet;
import com.twitter.finagle.Name;
import com.twitter.finagle.Resolver$;
import com.twitter.finagle.Service;
import com.twitter.finagle.ThriftMux;
import com.twitter.finagle.builder.ClientBuilder;
import com.twitter.finagle.client.StackBasedClient;
import com.twitter.finagle.stats.NullStatsReceiver;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.thrift.ClientId;
import com.twitter.finagle.thrift.ThriftClientFramedCodec;
import com.twitter.finagle.thrift.ThriftClientRequest;
import com.twitter.util.Duration;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.distributedlog.client.ClientConfig;
import org.apache.distributedlog.client.DistributedLogClientImpl;
import org.apache.distributedlog.client.monitor.MonitorServiceClient;
import org.apache.distributedlog.client.proxy.ClusterClient;
import org.apache.distributedlog.client.resolver.DefaultRegionResolver;
import org.apache.distributedlog.client.resolver.RegionResolver;
import org.apache.distributedlog.client.routing.RegionsRoutingService;
import org.apache.distributedlog.client.routing.RoutingService;
import org.apache.distributedlog.client.routing.RoutingUtils;
import org.apache.distributedlog.service.DistributedLogClient;
import org.apache.distributedlog.thrift.service.DistributedLogService;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;

public final class DistributedLogClientBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DistributedLogClientBuilder.class);
    private static final Random random = new Random(System.currentTimeMillis());
    private String name = null;
    private ClientId clientId = null;
    private RoutingService.Builder routingServiceBuilder = null;
    private ClientBuilder clientBuilder = null;
    private String serverRoutingServiceFinagleName = null;
    private StatsReceiver statsReceiver = new NullStatsReceiver();
    private StatsReceiver streamStatsReceiver = new NullStatsReceiver();
    private ClientConfig clientConfig = new ClientConfig();
    private boolean enableRegionStats = false;
    private final RegionResolver regionResolver = new DefaultRegionResolver();

    public static DistributedLogClientBuilder newBuilder() {
        return new DistributedLogClientBuilder();
    }

    public static DistributedLogClientBuilder newBuilder(DistributedLogClientBuilder builder) {
        DistributedLogClientBuilder newBuilder = new DistributedLogClientBuilder();
        newBuilder.name = builder.name;
        newBuilder.clientId = builder.clientId;
        newBuilder.clientBuilder = builder.clientBuilder;
        newBuilder.routingServiceBuilder = builder.routingServiceBuilder;
        newBuilder.statsReceiver = builder.statsReceiver;
        newBuilder.streamStatsReceiver = builder.streamStatsReceiver;
        newBuilder.enableRegionStats = builder.enableRegionStats;
        newBuilder.serverRoutingServiceFinagleName = builder.serverRoutingServiceFinagleName;
        newBuilder.clientConfig = ClientConfig.newConfig(builder.clientConfig);
        return newBuilder;
    }

    private DistributedLogClientBuilder() {
    }

    public DistributedLogClientBuilder name(String name) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.name = name;
        return newBuilder;
    }

    public DistributedLogClientBuilder clientId(ClientId clientId) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientId = clientId;
        return newBuilder;
    }

    public DistributedLogClientBuilder serverSet(ServerSet serverSet) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.routingServiceBuilder = RoutingUtils.buildRoutingService(serverSet);
        newBuilder.enableRegionStats = false;
        return newBuilder;
    }

    public DistributedLogClientBuilder serverSets(ServerSet local, ServerSet ... remotes) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        RoutingService.Builder[] builders = new RoutingService.Builder[remotes.length + 1];
        builders[0] = RoutingUtils.buildRoutingService(local);
        for (int i = 1; i < builders.length; ++i) {
            builders[i] = RoutingUtils.buildRoutingService(remotes[i - 1]);
        }
        newBuilder.routingServiceBuilder = RegionsRoutingService.newBuilder().resolver(this.regionResolver).routingServiceBuilders(builders);
        newBuilder.enableRegionStats = remotes.length > 0;
        return newBuilder;
    }

    public DistributedLogClientBuilder finagleNameStr(String finagleNameStr) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.routingServiceBuilder = RoutingUtils.buildRoutingService(finagleNameStr);
        newBuilder.enableRegionStats = false;
        return newBuilder;
    }

    public DistributedLogClientBuilder finagleNameStrs(String local, String ... remotes) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        RoutingService.Builder[] builders = new RoutingService.Builder[remotes.length + 1];
        builders[0] = RoutingUtils.buildRoutingService(local);
        for (int i = 1; i < builders.length; ++i) {
            builders[i] = RoutingUtils.buildRoutingService(remotes[i - 1]);
        }
        newBuilder.routingServiceBuilder = RegionsRoutingService.newBuilder().routingServiceBuilders(builders).resolver(this.regionResolver);
        newBuilder.enableRegionStats = remotes.length > 0;
        return newBuilder;
    }

    public DistributedLogClientBuilder uri(URI uri) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        String zkServers = uri.getAuthority().replace(";", ",");
        String[] zkServerList = StringUtils.split((String)zkServers, (char)',');
        String finagleNameStr = String.format("zk!%s!%s/.write_proxy", zkServerList[random.nextInt(zkServerList.length)], uri.getPath());
        newBuilder.routingServiceBuilder = RoutingUtils.buildRoutingService(finagleNameStr);
        newBuilder.enableRegionStats = false;
        return newBuilder;
    }

    public DistributedLogClientBuilder host(SocketAddress address) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.routingServiceBuilder = RoutingUtils.buildRoutingService(address);
        newBuilder.enableRegionStats = false;
        return newBuilder;
    }

    private DistributedLogClientBuilder routingServiceBuilder(RoutingService.Builder builder) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.routingServiceBuilder = builder;
        newBuilder.enableRegionStats = false;
        return newBuilder;
    }

    @VisibleForTesting
    public DistributedLogClientBuilder routingService(RoutingService routingService) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.routingServiceBuilder = RoutingUtils.buildRoutingService(routingService);
        newBuilder.enableRegionStats = false;
        return newBuilder;
    }

    public DistributedLogClientBuilder statsReceiver(StatsReceiver statsReceiver) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.statsReceiver = statsReceiver;
        return newBuilder;
    }

    public DistributedLogClientBuilder streamStatsReceiver(StatsReceiver streamStatsReceiver) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.streamStatsReceiver = streamStatsReceiver;
        return newBuilder;
    }

    public DistributedLogClientBuilder clientBuilder(ClientBuilder builder) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientBuilder = builder;
        return newBuilder;
    }

    public DistributedLogClientBuilder redirectBackoffStartMs(int ms) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientConfig.setRedirectBackoffStartMs(ms);
        return newBuilder;
    }

    public DistributedLogClientBuilder redirectBackoffMaxMs(int ms) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientConfig.setRedirectBackoffMaxMs(ms);
        return newBuilder;
    }

    public DistributedLogClientBuilder maxRedirects(int redirects) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientConfig.setMaxRedirects(redirects);
        return newBuilder;
    }

    public DistributedLogClientBuilder requestTimeoutMs(int timeoutMs) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientConfig.setRequestTimeoutMs(timeoutMs);
        return newBuilder;
    }

    public DistributedLogClientBuilder thriftmux(boolean enabled) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientConfig.setThriftMux(enabled);
        return newBuilder;
    }

    public DistributedLogClientBuilder streamFailfast(boolean enabled) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientConfig.setStreamFailfast(enabled);
        return newBuilder;
    }

    public DistributedLogClientBuilder streamNameRegex(String nameRegex) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientConfig.setStreamNameRegex(nameRegex);
        return newBuilder;
    }

    public DistributedLogClientBuilder handshakeWithClientInfo(boolean enabled) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientConfig.setHandshakeWithClientInfo(enabled);
        return newBuilder;
    }

    public DistributedLogClientBuilder periodicHandshakeIntervalMs(long intervalMs) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientConfig.setPeriodicHandshakeIntervalMs(intervalMs);
        return newBuilder;
    }

    public DistributedLogClientBuilder periodicOwnershipSyncIntervalMs(long intervalMs) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientConfig.setPeriodicOwnershipSyncIntervalMs(intervalMs);
        return newBuilder;
    }

    public DistributedLogClientBuilder periodicDumpOwnershipCache(boolean enabled) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientConfig.setPeriodicDumpOwnershipCacheEnabled(enabled);
        return newBuilder;
    }

    public DistributedLogClientBuilder periodicDumpOwnershipCacheIntervalMs(long intervalMs) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientConfig.setPeriodicDumpOwnershipCacheIntervalMs(intervalMs);
        return newBuilder;
    }

    public DistributedLogClientBuilder handshakeTracing(boolean enabled) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientConfig.setHandshakeTracingEnabled(enabled);
        return newBuilder;
    }

    public DistributedLogClientBuilder checksum(boolean enabled) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientConfig.setChecksumEnabled(enabled);
        return newBuilder;
    }

    public DistributedLogClientBuilder serverRoutingServiceFinagleNameStr(String nameStr) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.serverRoutingServiceFinagleName = nameStr;
        return newBuilder;
    }

    DistributedLogClientBuilder clientConfig(ClientConfig clientConfig) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder(this);
        newBuilder.clientConfig = ClientConfig.newConfig(clientConfig);
        return newBuilder;
    }

    public DistributedLogClient build() {
        return this.buildClient();
    }

    public MonitorServiceClient buildMonitorClient() {
        return this.buildClient();
    }

    ClusterClient buildServerRoutingServiceClient(String serverRoutingServiceFinagleName) {
        Name name;
        ClientBuilder builder = this.clientBuilder;
        if (null == builder) {
            builder = ClientBuilder.get().tcpConnectTimeout(Duration.fromMilliseconds((long)200L)).connectTimeout(Duration.fromMilliseconds((long)200L)).requestTimeout(Duration.fromSeconds((int)1)).retries(20);
            if (!this.clientConfig.getThriftMux()) {
                builder = builder.hostConnectionLimit(1);
            }
        }
        builder = this.clientConfig.getThriftMux() ? builder.stack((StackBasedClient)ThriftMux.client().withClientId(this.clientId)) : builder.codec((Function1)ThriftClientFramedCodec.apply((Option)Option.apply((Object)this.clientId)));
        try {
            name = Resolver$.MODULE$.eval(serverRoutingServiceFinagleName);
        }
        catch (Exception exc) {
            logger.error("Exception in Resolver.eval for name {}", (Object)serverRoutingServiceFinagleName, (Object)exc);
            throw new RuntimeException(exc);
        }
        Service client = ClientBuilder.safeBuildFactory((ClientBuilder)builder.dest(name).reportTo(this.statsReceiver.scope("routing"))).toService();
        DistributedLogService.ServiceToClient service = new DistributedLogService.ServiceToClient(client, (TProtocolFactory)new TBinaryProtocol.Factory());
        return new ClusterClient((Service<ThriftClientRequest, byte[]>)client, (DistributedLogService.ServiceIface)service);
    }

    DistributedLogClientImpl buildClient() {
        Preconditions.checkNotNull((Object)this.name, (Object)"No name provided.");
        Preconditions.checkNotNull((Object)this.clientId, (Object)"No client id provided.");
        Preconditions.checkNotNull((Object)this.routingServiceBuilder, (Object)"No routing service builder provided.");
        Preconditions.checkNotNull((Object)this.statsReceiver, (Object)"No stats receiver provided.");
        if (null == this.streamStatsReceiver) {
            this.streamStatsReceiver = new NullStatsReceiver();
        }
        Optional serverRoutingServiceClient = Optional.absent();
        if (null != this.serverRoutingServiceFinagleName) {
            serverRoutingServiceClient = Optional.of((Object)this.buildServerRoutingServiceClient(this.serverRoutingServiceFinagleName));
        }
        RoutingService routingService = this.routingServiceBuilder.statsReceiver(this.statsReceiver.scope("routing")).build();
        DistributedLogClientImpl clientImpl = new DistributedLogClientImpl(this.name, this.clientId, routingService, this.clientBuilder, this.clientConfig, (Optional<ClusterClient>)serverRoutingServiceClient, this.statsReceiver, this.streamStatsReceiver, this.regionResolver, this.enableRegionStats);
        routingService.startService();
        clientImpl.handshake();
        return clientImpl;
    }
}

