/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.AtomicDouble;
import com.twitter.common.base.MorePreconditions;
import com.twitter.common.stats.RecordingStat;
import com.twitter.common.stats.RecordingStatImpl;
import com.twitter.common.stats.RequestStats;
import com.twitter.common.stats.SampledStat;
import com.twitter.common.stats.Stat;
import com.twitter.common.stats.StatImpl;
import com.twitter.common.stats.StatRegistry;
import com.twitter.common.stats.StatsProvider;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Stats {
    private static final Logger LOG = Logger.getLogger(Stats.class.getName());
    private static final Pattern NOT_NAME_CHAR = Pattern.compile("[^A-Za-z0-9_]");
    private static final ConcurrentMap<String, Stat<?>> VAR_MAP = new MapMaker().makeMap();
    private static final Collection<RecordingStat<? extends Number>> ORDERED_NUMERIC_STATS = new ConcurrentLinkedQueue<RecordingStat<? extends Number>>();
    private static final Cache<String, RecordingStat<? extends Number>> NUMERIC_STATS = CacheBuilder.newBuilder().build();
    public static final StatsProvider STATS_PROVIDER = new StatsProvider(){
        private final StatsProvider untracked = new StatsProvider(){

            public AtomicLong makeCounter(String name) {
                final AtomicLong longVar = new AtomicLong();
                Stats.exportStatic(new StatImpl<Long>(name){

                    public Long read() {
                        return longVar.get();
                    }
                });
                return longVar;
            }

            public <T extends Number> Stat<T> makeGauge(String name, final Supplier<T> gauge) {
                return Stats.exportStatic(new StatImpl<T>(name){

                    public T read() {
                        return (Number)gauge.get();
                    }
                });
            }

            public StatsProvider untracked() {
                return this;
            }

            public StatsProvider.RequestTimer makeRequestTimer(String name) {
                throw new UnsupportedOperationException();
            }
        };

        public <T extends Number> Stat<T> makeGauge(String name, final Supplier<T> gauge) {
            return Stats.export(new StatImpl<T>(name){

                public T read() {
                    return (Number)gauge.get();
                }
            });
        }

        public AtomicLong makeCounter(String name) {
            return Stats.exportLong(name);
        }

        public StatsProvider untracked() {
            return this.untracked;
        }

        public StatsProvider.RequestTimer makeRequestTimer(String name) {
            return new RequestStats(name);
        }
    };
    public static final StatRegistry STAT_REGISTRY = new StatRegistry(){

        public Iterable<RecordingStat<? extends Number>> getStats() {
            return Stats.getNumericVariables();
        }
    };

    public static String normalizeName(String name) {
        return NOT_NAME_CHAR.matcher(name).replaceAll("_");
    }

    static String validateName(String name) {
        String normalized = Stats.normalizeName(name);
        if (!name.equals(normalized)) {
            LOG.warning("Invalid stat name " + name + " exported as " + normalized);
        }
        return normalized;
    }

    public static <T extends Number> Stat<T> export(Stat<T> var) {
        String validatedName = Stats.validateName(MorePreconditions.checkNotBlank((String)var.getName()));
        ExportStat exportStat = new ExportStat(validatedName, var);
        try {
            Stat exported;
            Stat stat = exported = (Stat)NUMERIC_STATS.get((Object)validatedName, (Callable)exportStat);
            return stat;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Unexpected error exporting stat " + validatedName, e.getCause());
        }
        finally {
            if (!exportStat.called.get()) {
                LOG.warning("Re-using already registered variable for key " + validatedName);
            }
        }
    }

    public static Stat<String> exportString(Stat<String> var) {
        return Stats.exportStatic(var);
    }

    public static void exportAll(Iterable<Stat<? extends Number>> vars) {
        for (Stat<? extends Number> var : vars) {
            Stats.export(var);
        }
    }

    public static AtomicInteger export(String name, final AtomicInteger intVar) {
        Stats.export(new SampledStat<Integer>(name, Integer.valueOf(0)){

            @Override
            public Integer doSample() {
                return intVar.get();
            }
        });
        return intVar;
    }

    public static AtomicInteger exportInt(String name) {
        return Stats.exportInt(name, 0);
    }

    public static AtomicInteger exportInt(String name, int initialValue) {
        return Stats.export(name, new AtomicInteger(initialValue));
    }

    public static AtomicLong export(String name, final AtomicLong longVar) {
        Stats.export(new StatImpl<Long>(name){

            public Long read() {
                return longVar.get();
            }
        });
        return longVar;
    }

    public static AtomicLong exportLong(String name) {
        return Stats.exportLong(name, 0L);
    }

    public static AtomicLong exportLong(String name, long initialValue) {
        return Stats.export(name, new AtomicLong(initialValue));
    }

    public static AtomicDouble export(String name, final AtomicDouble doubleVar) {
        Stats.export(new StatImpl<Double>(name){

            public Double read() {
                return doubleVar.doubleValue();
            }
        });
        return doubleVar;
    }

    public static AtomicDouble exportDouble(String name) {
        return Stats.exportDouble(name, 0.0);
    }

    public static AtomicDouble exportDouble(String name, double initialValue) {
        return Stats.export(name, new AtomicDouble(initialValue));
    }

    public static void exportSize(String name, final Collection<?> collection) {
        Stats.export(new StatImpl<Integer>(name){

            public Integer read() {
                return collection.size();
            }
        });
    }

    public static void exportSize(String name, final Map<?, ?> map) {
        Stats.export(new StatImpl<Integer>(name){

            public Integer read() {
                return map.size();
            }
        });
    }

    public static void exportSize(String name, final Cache<?, ?> cache) {
        Stats.export(new StatImpl<Long>(name){

            public Long read() {
                return cache.size();
            }
        });
    }

    public static <T> Stat<T> exportStatic(Stat<T> var) {
        String validatedName = Stats.validateName(MorePreconditions.checkNotBlank((String)var.getName()));
        Stats.exportStaticInternal(validatedName, var);
        return var;
    }

    private static void exportStaticInternal(String name, Stat<?> stat) {
        if (VAR_MAP.put(name, stat) != null) {
            LOG.warning("Warning - exported variable collision on " + name);
        }
    }

    public static Iterable<Stat<?>> getVariables() {
        return ImmutableList.copyOf(VAR_MAP.values());
    }

    static Iterable<RecordingStat<? extends Number>> getNumericVariables() {
        return ImmutableList.copyOf(ORDERED_NUMERIC_STATS);
    }

    @VisibleForTesting
    public static void flush() {
        VAR_MAP.clear();
        ORDERED_NUMERIC_STATS.clear();
        NUMERIC_STATS.invalidateAll();
    }

    public static <T> Stat<T> getVariable(String name) {
        MorePreconditions.checkNotBlank((String)name);
        Stat stat = (Stat)VAR_MAP.get(name);
        return stat;
    }

    private static class ExportStat
    implements Callable<RecordingStat<? extends Number>> {
        private final AtomicBoolean called = new AtomicBoolean(false);
        private final RecordingStat<? extends Number> stat;
        private final String name;

        private <T extends Number> ExportStat(String name, Stat<T> stat) {
            this.name = name;
            this.stat = stat instanceof RecordingStat ? (RecordingStat)stat : new RecordingStatImpl<T>(stat);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RecordingStat<? extends Number> call() {
            try {
                Stats.exportStaticInternal(this.name, this.stat);
                ORDERED_NUMERIC_STATS.add(this.stat);
                RecordingStat<? extends Number> recordingStat = this.stat;
                return recordingStat;
            }
            finally {
                this.called.set(true);
            }
        }
    }
}

