/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNS {
    private static final Logger LOG = LoggerFactory.getLogger(DNS.class);
    private static final String cachedHostname = DNS.resolveLocalHostname();
    private static final String cachedHostAddress = DNS.resolveLocalHostIPAddress();
    private static final String LOCALHOST = "localhost";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reverseDns(InetAddress hostIp, String ns) throws NamingException {
        Attributes attribute;
        String[] parts = hostIp.getHostAddress().split("\\.");
        if (parts.length != 4) {
            throw new NamingException("IPV6");
        }
        String reverseIP = parts[3] + "." + parts[2] + "." + parts[1] + "." + parts[0] + ".in-addr.arpa";
        try (InitialDirContext ictx = new InitialDirContext();){
            attribute = ictx.getAttributes("dns://" + (ns == null ? "" : ns) + "/" + reverseIP, new String[]{"PTR"});
        }
        return attribute.get("PTR").get().toString();
    }

    private static NetworkInterface getSubinterface(String strInterface) throws SocketException {
        Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
        while (nifs.hasMoreElements()) {
            Enumeration<NetworkInterface> subNifs = nifs.nextElement().getSubInterfaces();
            while (subNifs.hasMoreElements()) {
                NetworkInterface nif = subNifs.nextElement();
                if (!nif.getName().equals(strInterface)) continue;
                return nif;
            }
        }
        return null;
    }

    private static LinkedHashSet<InetAddress> getSubinterfaceInetAddrs(NetworkInterface nif) {
        LinkedHashSet<InetAddress> addrs = new LinkedHashSet<InetAddress>();
        Enumeration<NetworkInterface> subNifs = nif.getSubInterfaces();
        while (subNifs.hasMoreElements()) {
            NetworkInterface subNif = subNifs.nextElement();
            addrs.addAll(Collections.list(subNif.getInetAddresses()));
        }
        return addrs;
    }

    public static String[] getIPs(String strInterface) throws UnknownHostException {
        return DNS.getIPs(strInterface, true);
    }

    public static String[] getIPs(String strInterface, boolean returnSubinterfaces) throws UnknownHostException {
        NetworkInterface netIf;
        if ("default".equals(strInterface)) {
            return new String[]{cachedHostAddress};
        }
        try {
            netIf = NetworkInterface.getByName(strInterface);
            if (netIf == null) {
                netIf = DNS.getSubinterface(strInterface);
            }
        }
        catch (SocketException e) {
            LOG.warn("I/O error finding interface " + strInterface + ": " + e.getMessage());
            return new String[]{cachedHostAddress};
        }
        if (netIf == null) {
            throw new UnknownHostException("No such interface " + strInterface);
        }
        LinkedHashSet<InetAddress> allAddrs = new LinkedHashSet<InetAddress>();
        allAddrs.addAll(Collections.list(netIf.getInetAddresses()));
        if (!returnSubinterfaces) {
            allAddrs.removeAll(DNS.getSubinterfaceInetAddrs(netIf));
        }
        String[] ips = new String[allAddrs.size()];
        int i = 0;
        for (InetAddress addr : allAddrs) {
            ips[i++] = addr.getHostAddress();
        }
        return ips;
    }

    public static String getDefaultIP(String strInterface) throws UnknownHostException {
        String[] ips = DNS.getIPs(strInterface);
        return ips[0];
    }

    public static String[] getHosts(String strInterface, String nameserver) throws UnknownHostException {
        String[] ips = DNS.getIPs(strInterface);
        Vector<String> hosts = new Vector<String>();
        for (int ctr = 0; ctr < ips.length; ++ctr) {
            try {
                hosts.add(DNS.reverseDns(InetAddress.getByName(ips[ctr]), nameserver));
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                continue;
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (hosts.isEmpty()) {
            LOG.warn("Unable to determine hostname for interface " + strInterface);
            return new String[]{cachedHostname};
        }
        return hosts.toArray(new String[hosts.size()]);
    }

    private static String resolveLocalHostname() {
        String localhost;
        try {
            localhost = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to determine local hostname -falling back to \"localhost\"", (Throwable)e);
            localhost = LOCALHOST;
        }
        return localhost;
    }

    private static String resolveLocalHostIPAddress() {
        String address;
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to determine address of the host-falling back to \"localhost\" address", (Throwable)e);
            try {
                address = InetAddress.getByName(LOCALHOST).getHostAddress();
            }
            catch (UnknownHostException noLocalHostAddressException) {
                LOG.error("Unable to determine local loopback address of \"localhost\" -this system's network configuration is unsupported", (Throwable)e);
                address = null;
            }
        }
        return address;
    }

    public static String[] getHosts(String strInterface) throws UnknownHostException {
        return DNS.getHosts(strInterface, null);
    }

    public static String getDefaultHost(String strInterface, String nameserver) throws UnknownHostException {
        if ("default".equals(strInterface)) {
            return cachedHostname;
        }
        if ("default".equals(nameserver)) {
            return DNS.getDefaultHost(strInterface);
        }
        String[] hosts = DNS.getHosts(strInterface, nameserver);
        return hosts[0];
    }

    public static String getDefaultHost(String strInterface) throws UnknownHostException {
        return DNS.getDefaultHost(strInterface, null);
    }
}

