/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.application;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.twitter.common.application.StartupStage;
import com.twitter.common.base.ExceptionalCommand;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class StartupRegistry
implements ExceptionalCommand<Exception> {
    private static final Logger LOG = Logger.getLogger(StartupRegistry.class.getName());
    private final Set<ExceptionalCommand> startupActions;
    private final AtomicBoolean started = new AtomicBoolean(false);

    @Inject
    public StartupRegistry(@StartupStage Set<ExceptionalCommand> startupActions) {
        this.startupActions = (Set)Preconditions.checkNotNull(startupActions);
    }

    public void execute() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            LOG.warning("Startup actions cannot be executed more than once, ignoring.");
        }
        for (ExceptionalCommand startupAction : this.startupActions) {
            startupAction.execute();
        }
    }
}

