/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.util.ArrayList;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.CayenneTableModel;

public class DbJoinTableModel
extends CayenneTableModel {
    static final int SOURCE = 0;
    static final int TARGET = 1;
    protected DbRelationship relationship;
    protected DbEntity source;
    protected DbEntity target;
    private boolean editable;

    public DbJoinTableModel(DbRelationship relationship, ProjectController mediator, Object src) {
        super(mediator, src, new ArrayList<DbJoin>(relationship.getJoins()));
        this.relationship = relationship;
        this.source = (DbEntity)relationship.getSourceEntity();
        this.target = (DbEntity)relationship.getTargetEntity();
    }

    public DbJoinTableModel(DbRelationship relationship, ProjectController mediator, Object src, boolean editable) {
        this(relationship, mediator, src);
        this.editable = editable;
    }

    public Class getElementsClass() {
        return DbJoin.class;
    }

    public void commit() {
        this.relationship.setJoins(this.getObjectList());
    }

    public String getOrderingKey() {
        return null;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Source";
        }
        if (column == 1) {
            return "Target";
        }
        return "";
    }

    public DbJoin getJoin(int row) {
        return row >= 0 && row < this.objectList.size() ? (DbJoin)this.objectList.get(row) : null;
    }

    public Object getValueAt(int row, int column) {
        DbJoin join = this.getJoin(row);
        if (join == null) {
            return null;
        }
        if (column == 0) {
            return join.getSourceName();
        }
        if (column == 1) {
            return join.getTargetName();
        }
        return null;
    }

    public void setUpdatedValueAt(Object aValue, int row, int column) {
        DbJoin join = this.getJoin(row);
        if (join == null) {
            return;
        }
        String value = (String)aValue;
        if (column == 0) {
            if (this.source == null || this.source.getAttribute(value) == null) {
                value = null;
            }
            join.setSourceName(value);
        } else if (column == 1) {
            if (this.target == null || this.target.getAttribute(value) == null) {
                value = null;
            }
            join.setTargetName(value);
        }
        this.fireTableRowsUpdated(row, row);
    }

    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return this.relationship.getSourceEntity() != null && this.editable;
        }
        if (col == 1) {
            return this.relationship.getTargetEntity() != null && this.editable;
        }
        return false;
    }
}

