/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.editor.EditorView;
import org.apache.cayenne.modeler.undo.JTextFieldUndoListener;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.SQLTemplate;

public class TextCompoundEdit
extends CompoundEdit
implements DocumentListener {
    private TextAdapter adapter;
    private JTextComponent editor;
    private TreePath treePath;
    private int selectedTabIndex;
    private JTabbedPane tabbedPane;
    private Object targetObject;
    private JTextFieldUndoListener listener;

    public Object getTargetObject() {
        return this.targetObject;
    }

    public TextCompoundEdit(TextAdapter adapter, JTextFieldUndoListener listener) {
        this(adapter.getComponent(), listener);
        this.adapter = adapter;
    }

    public TextCompoundEdit(JTextComponent editor, JTextFieldUndoListener listener) {
        this.editor = editor;
        this.listener = listener;
        EditorView editorView = ((CayenneModelerFrame)Application.getInstance().getFrameController().getView()).getView();
        this.treePath = editorView.getProjectTreeView().getSelectionPath();
        DefaultMutableTreeNode newPath = (DefaultMutableTreeNode)this.treePath.getLastPathComponent();
        this.targetObject = newPath.getUserObject();
        if (this.targetObject instanceof ObjEntity) {
            this.tabbedPane = editorView.getObjDetailView();
        }
        if (this.targetObject instanceof DbEntity) {
            this.tabbedPane = editorView.getDbDetailView();
        }
        if (this.targetObject instanceof Embeddable) {
            this.tabbedPane = editorView.getEmbeddableView();
        }
        if (this.targetObject instanceof SQLTemplate) {
            this.tabbedPane = editorView.getSqlTemplateView();
        }
        if (this.targetObject instanceof EJBQLQuery) {
            this.tabbedPane = editorView.getEjbqlQueryView();
        }
        if (this.targetObject instanceof DataNode) {
            this.tabbedPane = editorView.getDataNodeView();
        }
        if (this.targetObject instanceof DataMap) {
            this.tabbedPane = editorView.getDataMapView();
        }
        if (this.tabbedPane != null) {
            this.selectedTabIndex = this.tabbedPane.getSelectedIndex();
        }
    }

    private void restoreSelections() {
        EditorView editorView = ((CayenneModelerFrame)Application.getInstance().getFrameController().getView()).getView();
        editorView.getProjectTreeView().getSelectionModel().setSelectionPath(this.treePath);
        if (this.tabbedPane != null) {
            this.tabbedPane.setSelectedIndex(this.selectedTabIndex);
        }
    }

    public void insertUpdate(final DocumentEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int offset = e.getOffset() + e.getLength();
                offset = Math.min(offset, TextCompoundEdit.this.editor.getDocument().getLength());
                TextCompoundEdit.this.editor.setCaretPosition(offset);
            }
        });
    }

    public void removeUpdate(DocumentEvent e) {
        this.editor.setCaretPosition(e.getOffset());
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public boolean isInProgress() {
        return false;
    }

    public void redo() throws CannotRedoException {
        this.restoreSelections();
        if (this.canRedo()) {
            super.redo();
        } else {
            this.die();
        }
        this.editor.requestFocusInWindow();
    }

    public void undo() throws CannotUndoException {
        this.restoreSelections();
        this.listener.finishCurrentEdit();
        if (this.canUndo()) {
            super.undo();
        } else {
            this.die();
        }
        if (this.adapter != null) {
            this.adapter.updateModel();
        }
        this.editor.requestFocusInWindow();
        this.editor.selectAll();
    }

    public synchronized String getRedoPresentationName() {
        return "Redo Text Change";
    }

    public synchronized String getUndoPresentationName() {
        return "Undo Text Change";
    }

    public JTextComponent getEditor() {
        return this.editor;
    }

    public void watchCaretPosition() {
        this.editor.getDocument().addDocumentListener(this);
    }

    public void stopWatchingCaretPosition() {
        this.editor.getDocument().removeDocumentListener(this);
    }
}

