/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.hessian.service;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.cayenne.remote.RemoteService;
import org.apache.cayenne.remote.hessian.service.HessianService;

public class HessianServlet
extends com.caucho.hessian.server.HessianServlet {
    static final String API_CLASS_PARAMETER = "api-class";
    static final String SERVICE_CLASS_PARAMETER = "service-class";
    private HessianService service;

    public void init(ServletConfig config) throws ServletException {
        Class apiClass = this.createAPIClass(config);
        if (apiClass == null) {
            throw new ServletException("Can't configure service API class");
        }
        this.setAPIClass(apiClass);
        HessianService service = this.createService(config);
        if (service == null) {
            throw new ServletException("Error configuring service ");
        }
        service.init(config);
        this.setSerializerFactory(service.createSerializerFactory());
        this.setService(service);
        this.service = service;
        super.init(config);
    }

    public void destroy() {
        if (this.service != null) {
            this.service.destroy();
            this.service = null;
        }
        super.destroy();
    }

    protected HessianService createService(ServletConfig config) throws ServletException {
        String className = config.getInitParameter(SERVICE_CLASS_PARAMETER);
        if (className == null) {
            return new HessianService();
        }
        try {
            Class<?> serviceClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            if (!HessianService.class.isAssignableFrom(serviceClass)) {
                throw new ServletException("Service class must be a subclass of HessianService: " + className);
            }
            return (HessianService)serviceClass.newInstance();
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("Error instantiating service class " + className, (Throwable)e);
        }
    }

    protected Class createAPIClass(ServletConfig config) throws ServletException {
        String interfaceName = config.getInitParameter(API_CLASS_PARAMETER);
        if (interfaceName == null) {
            return RemoteService.class;
        }
        try {
            Class<?> serviceInterface = Class.forName(interfaceName, true, Thread.currentThread().getContextClassLoader());
            if (!RemoteService.class.isAssignableFrom(serviceInterface)) {
                throw new ServletException("Service interface must be a subinterface of RemoteService: " + interfaceName);
            }
            return serviceInterface;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("Error instantiating service interface " + interfaceName, (Throwable)e);
        }
    }
}

