/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlserver;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.jdbc.BatchAction;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.InsertBatchQuery;

public class SQLServerBatchAction
extends BatchAction {
    public SQLServerBatchAction(BatchQuery batchQuery, DbAdapter adapter, EntityResolver entityResolver) {
        super(batchQuery, adapter, entityResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        boolean identityOverride = this.expectsToOverrideIdentityColumns();
        if (identityOverride) {
            this.setIdentityInsert(connection, true);
        }
        try {
            super.performAction(connection, observer);
        }
        finally {
            if (identityOverride) {
                this.setIdentityInsert(connection, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIdentityInsert(Connection connection, boolean on) throws SQLException {
        String flag = on ? " ON" : " OFF";
        String configSQL = "SET IDENTITY_INSERT " + this.query.getDbEntity().getFullyQualifiedName() + flag;
        QueryLogger.logQuery(configSQL, Collections.EMPTY_LIST);
        Statement statement = connection.createStatement();
        try {
            statement.execute(configSQL);
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    protected boolean expectsToOverrideIdentityColumns() {
        if (this.getAdapter().supportsGeneratedKeys()) {
            return false;
        }
        if (!(this.query instanceof InsertBatchQuery) || this.query.getDbEntity() == null) {
            return false;
        }
        for (DbAttribute attribute : this.query.getDbEntity().getAttributes()) {
            if (!attribute.isGenerated()) continue;
            return true;
        }
        return false;
    }
}

