/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.pref;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DbGenerator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.pref.PreferenceDetail;
import org.apache.cayenne.pref.PreferenceException;
import org.apache.cayenne.pref.PreferenceService;

public abstract class CayennePreferenceService
implements PreferenceService {
    public static final int MIN_SAVE_INTERVAL = 500;
    public static final int DEFAULT_SAVE_INTERVAL = 20000;
    public static final String SAVE_INTERVAL_KEY = "saveInterval";
    protected int saveInterval = 20000;
    protected Timer saveTimer;
    protected DataContext dataContext;
    protected String defaultDomain;

    public CayennePreferenceService(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public void setDataContext(DataContext preferencesContext) {
        this.dataContext = preferencesContext;
    }

    public int getSaveInterval() {
        return this.saveInterval;
    }

    public void setSaveInterval(int ms) {
        if (this.saveInterval != ms) {
            this.saveInterval = ms;
            this.getPreferenceDomain().getDetail(SAVE_INTERVAL_KEY, true).setIntProperty(SAVE_INTERVAL_KEY, ms);
        }
    }

    public Domain getDomain(String name, boolean create) {
        List results = this.getDataContext().performQuery("TopLevelDomain", Collections.singletonMap("name", name), false);
        if (results.size() > 1) {
            throw new CayenneRuntimeException("Found " + results.size() + " Domain objects for name '" + name + "', only one expected.");
        }
        if (results.size() == 1) {
            return (Domain)((Object)results.get(0));
        }
        if (!create) {
            return null;
        }
        Domain domain = (Domain)((Object)this.getDataContext().newObject(Domain.class));
        domain.setLevel(new Integer(0));
        domain.setName(name);
        this.savePreferences();
        return domain;
    }

    public void stopOnShutdown() {
        Thread shutdown = new Thread("CayennePrefrencesService Shutdown"){

            public void run() {
                CayennePreferenceService.this.stopService();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdown);
    }

    public void savePreferences() {
        DataContext context = this.dataContext;
        if (context != null) {
            context.commitChanges();
        }
    }

    protected Domain getPreferenceDomain() {
        Domain defaultDomain = this.getDomain(this.defaultDomain, true);
        return defaultDomain.getSubdomain(this.getClass());
    }

    protected void initPreferences() {
        Domain preferenceDomain = this.getPreferenceDomain();
        PreferenceDetail saveInterval = preferenceDomain.getDetail(SAVE_INTERVAL_KEY, false);
        if (saveInterval != null) {
            this.setSaveInterval(saveInterval.getIntProperty(SAVE_INTERVAL_KEY, 20000));
        }
    }

    protected void initSchema() {
        DataDomain domain = this.dataContext.getParentDataDomain();
        Iterator i$ = domain.getDataMaps().iterator();
        while (i$.hasNext()) {
            DataMap dataMap;
            DataMap map = dataMap = (DataMap)i$.next();
            DataNode node = domain.lookupDataNode(map);
            DbAdapter adapter = node.getAdapter();
            DbGenerator generator = new DbGenerator(adapter, map);
            try {
                generator.runGenerator(node.getDataSource());
            }
            catch (Throwable th) {
                throw new PreferenceException("Error creating preferences DB", th);
            }
        }
    }

    protected void startTimer() {
        TimerTask saveTask = new TimerTask(){

            public void run() {
                CayennePreferenceService.this.savePreferences();
            }
        };
        int interval = this.saveInterval > 500 ? this.saveInterval : 500;
        this.saveTimer = new Timer(true);
        this.saveTimer.schedule(saveTask, interval, (long)interval);
    }
}

