/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.random;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Properties;
import org.apache.commons.crypto.random.CryptoRandom;
import org.apache.commons.crypto.utils.Utils;

final class JavaCryptoRandom
implements CryptoRandom {
    private final SecureRandom instance;

    public JavaCryptoRandom(Properties properties) {
        SecureRandom tmp;
        try {
            tmp = SecureRandom.getInstance(properties.getProperty("commons.crypto.secure.random.java.algorithm", "SHA1PRNG"));
        }
        catch (NoSuchAlgorithmException e) {
            tmp = new SecureRandom();
        }
        this.instance = tmp;
    }

    @Override
    public void close() {
    }

    protected int next(int numBits) {
        Utils.checkArgument(numBits >= 0 && numBits <= 32);
        return this.instance.nextInt() >>> 32 - numBits;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.instance.nextBytes(bytes);
    }
}

