/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.moment;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.stat.descriptive.moment.VectorialMean;
import org.junit.Assert;
import org.junit.Test;

public class VectorialMeanTest {
    private double[][] points = new double[][]{{1.2, 2.3, 4.5}, {-0.7, 2.3, 5.0}, {3.1, 0.0, -3.1}, {6.0, 1.2, 4.2}, {-0.7, 2.3, 5.0}};

    @Test
    public void testMismatch() {
        try {
            new VectorialMean(8).increment(new double[5]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dme) {
            Assert.assertEquals((Object)5, (Object)dme.getArgument());
            Assert.assertEquals((long)8L, (long)dme.getDimension());
        }
    }

    @Test
    public void testSimplistic() {
        VectorialMean stat = new VectorialMean(2);
        stat.increment(new double[]{-1.0, 1.0});
        stat.increment(new double[]{1.0, -1.0});
        double[] mean = stat.getResult();
        Assert.assertEquals((double)0.0, (double)mean[0], (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)mean[1], (double)1.0E-12);
    }

    @Test
    public void testBasicStats() {
        VectorialMean stat = new VectorialMean(this.points[0].length);
        for (int i = 0; i < this.points.length; ++i) {
            stat.increment(this.points[i]);
        }
        Assert.assertEquals((long)this.points.length, (long)stat.getN());
        double[] mean = stat.getResult();
        double[] refMean = new double[]{1.78, 1.62, 3.12};
        for (int i = 0; i < mean.length; ++i) {
            Assert.assertEquals((double)refMean[i], (double)mean[i], (double)1.0E-12);
        }
    }

    @Test
    public void testSerial() {
        VectorialMean stat = new VectorialMean(this.points[0].length);
        for (int i = 0; i < this.points.length; ++i) {
            stat.increment(this.points[i]);
        }
        Assert.assertEquals((Object)stat, (Object)TestUtils.serializeAndRecover(stat));
    }
}

