/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.distribution;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math4.legacy.core.Pair;
import org.apache.commons.math4.legacy.distribution.MixtureMultivariateRealDistribution;
import org.apache.commons.math4.legacy.distribution.MultivariateNormalDistribution;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.NotPositiveException;

public class MixtureMultivariateNormalDistribution
extends MixtureMultivariateRealDistribution<MultivariateNormalDistribution> {
    public MixtureMultivariateNormalDistribution(List<Pair<Double, MultivariateNormalDistribution>> components) throws NotPositiveException, DimensionMismatchException {
        super(components);
    }

    public MixtureMultivariateNormalDistribution(double[] weights, double[][] means, double[][][] covariances) throws NotPositiveException, DimensionMismatchException {
        this(MixtureMultivariateNormalDistribution.createComponents(weights, means, covariances));
    }

    private static List<Pair<Double, MultivariateNormalDistribution>> createComponents(double[] weights, double[][] means, double[][][] covariances) {
        ArrayList<Pair<Double, MultivariateNormalDistribution>> mvns = new ArrayList<Pair<Double, MultivariateNormalDistribution>>(weights.length);
        for (int i = 0; i < weights.length; ++i) {
            MultivariateNormalDistribution dist = new MultivariateNormalDistribution(means[i], covariances[i]);
            mvns.add((Pair<Double, MultivariateNormalDistribution>)new Pair((Object)weights[i], (Object)dist));
        }
        return mvns;
    }
}

