/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.neuralnet.sofm.util;

import java.util.function.LongToDoubleFunction;
import org.apache.commons.math4.neuralnet.internal.NeuralNetException;

public class ExponentialDecayFunction
implements LongToDoubleFunction {
    private final double a;
    private final double oneOverB;

    public ExponentialDecayFunction(double initValue, double valueAtNumCall, long numCall) {
        if (initValue <= 0.0) {
            throw new NeuralNetException("Number {0} is not strictly positive", initValue);
        }
        if (valueAtNumCall <= 0.0) {
            throw new NeuralNetException("Number {0} is not strictly positive", valueAtNumCall);
        }
        if (valueAtNumCall >= initValue) {
            throw new NeuralNetException("Number {0} is larger than {1}", valueAtNumCall, initValue);
        }
        if (numCall <= 0L) {
            throw new NeuralNetException("Number {0} is not strictly positive", numCall);
        }
        this.a = initValue;
        this.oneOverB = -Math.log(valueAtNumCall / initValue) / (double)numCall;
    }

    @Override
    public double applyAsDouble(long numCall) {
        return this.a * Math.exp((double)(-numCall) * this.oneOverB);
    }
}

