/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin.mojos;

import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.release.plugin.mojos.CommonsSiteCompressionMojo;
import org.apache.maven.api.plugin.testing.InjectMojo;
import org.apache.maven.api.plugin.testing.MojoTest;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@MojoTest
public class CommonsSiteCompressionMojoTest {
    private static final String COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH = "target/testing-commons-release-plugin";

    @BeforeEach
    public void setUp() throws Exception {
        File testingDirectory = new File(COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH);
        if (testingDirectory.exists()) {
            FileUtils.deleteDirectory((File)testingDirectory);
        }
    }

    @Test
    @InjectMojo(goal="compress-site", pom="src/test/resources/mojos/compress-site/compress-site-failure.xml")
    public void testCompressSiteDirNonExistentFailure(CommonsSiteCompressionMojo mojo) throws Exception {
        try {
            mojo.execute();
        }
        catch (MojoFailureException e) {
            Assert.assertEquals((Object)"\"mvn site\" was not run before this goal, or a siteDirectory did not exist.", (Object)e.getMessage());
        }
    }

    @Test
    @InjectMojo(goal="compress-site", pom="src/test/resources/mojos/compress-site/compress-site.xml")
    public void testCompressSiteSuccess(CommonsSiteCompressionMojo mojo) throws Exception {
        File testingDirectory = new File(COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH);
        testingDirectory.mkdir();
        mojo.execute();
        File siteZip = new File("target/testing-commons-release-plugin/site.zip");
        TestCase.assertTrue((boolean)siteZip.exists());
    }

    @Test
    @InjectMojo(goal="compress-site", pom="src/test/resources/mojos/compress-site/compress-site-disabled.xml")
    public void testDisabled(CommonsSiteCompressionMojo mojo) throws Exception {
        mojo.execute();
        File testingDirectory = new File(COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH);
        Assert.assertFalse((boolean)testingDirectory.exists());
    }
}

