/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.discovery.listeners;

import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.ws.discovery.internal.WSDiscoveryServiceImpl;

public class WSDiscoveryServerListener
implements ServerLifeCycleListener {
    private static final String WS_DISCOVERY_SERVICE_NS = "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01";
    final Bus bus;
    volatile WSDiscoveryServiceImpl service;

    public WSDiscoveryServerListener(Bus bus) {
        this.bus = bus;
    }

    private synchronized WSDiscoveryServiceImpl getService() {
        if (this.service == null) {
            this.service = (WSDiscoveryServiceImpl)this.bus.getExtension(WSDiscoveryServiceImpl.class);
            if (this.service == null) {
                this.service = WSDiscoveryServerListener.getStaticService();
                this.bus.setExtension((Object)this.service, WSDiscoveryServiceImpl.class);
            }
        }
        return this.service;
    }

    private static WSDiscoveryServiceImpl getStaticService() {
        return WSDiscoveryServiceImplHolder.INSTANCE;
    }

    public void startServer(Server server) {
        if (this.isWsDiscoveryServer(server)) {
            return;
        }
        this.getService().serverStarted(server);
    }

    public void stopServer(Server server) {
        if (this.isWsDiscoveryServer(server)) {
            return;
        }
        this.getService().serverStopped(server);
    }

    private boolean isWsDiscoveryServer(Server server) {
        QName sn = ServiceModelUtil.getServiceQName((EndpointInfo)server.getEndpoint().getEndpointInfo());
        return WS_DISCOVERY_SERVICE_NS.equals(sn.getNamespaceURI());
    }

    private static final class WSDiscoveryServiceImplHolder {
        private static final WSDiscoveryServiceImpl INSTANCE;

        private WSDiscoveryServiceImplHolder() {
        }

        static {
            Bus bus = BusFactory.newInstance().createBus();
            INSTANCE = new WSDiscoveryServiceImpl(bus);
        }
    }
}

