/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.adouble;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.apache.datasketches.tuple.AnotB;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AdoubleAnotBTest {
    private static final DoubleSummary.Mode mode = DoubleSummary.Mode.Sum;
    private final Results results = new Results();

    private static void threeMethodsWithTheta(AnotB<DoubleSummary> aNotB, Sketch<DoubleSummary> skA, Sketch<DoubleSummary> skB, org.apache.datasketches.theta.Sketch skThetaB, Results results) {
        CompactSketch result;
        if (skA != null) {
            try {
                aNotB.setA(skA);
                aNotB.notB(skB);
                result = aNotB.getResult(true);
                results.check((CompactSketch<DoubleSummary>)result);
            }
            catch (SketchesArgumentException sketchesArgumentException) {
                // empty catch block
            }
        }
        if (skA == null || skB == null) {
            try {
                result = AnotB.aNotB(skA, skB);
                Assert.fail();
            }
            catch (SketchesArgumentException sketchesArgumentException) {}
        } else {
            result = AnotB.aNotB(skA, skB);
            results.check((CompactSketch<DoubleSummary>)result);
        }
        if (skA == null || skThetaB == null) {
            try {
                result = AnotB.aNotB(skA, (org.apache.datasketches.theta.Sketch)skThetaB);
                Assert.fail();
            }
            catch (SketchesArgumentException sketchesArgumentException) {}
        } else {
            result = AnotB.aNotB(skA, (org.apache.datasketches.theta.Sketch)skThetaB);
            results.check((CompactSketch<DoubleSummary>)result);
        }
        if (skA == null) {
            try {
                aNotB.setA(skA);
                Assert.fail();
            }
            catch (SketchesArgumentException sketchesArgumentException) {}
        } else {
            aNotB.setA(skA);
            aNotB.notB(skB);
            result = aNotB.getResult(true);
            results.check((CompactSketch<DoubleSummary>)result);
        }
        if (skA == null) {
            try {
                aNotB.setA(skA);
                Assert.fail();
            }
            catch (SketchesArgumentException sketchesArgumentException) {}
        } else {
            aNotB.setA(skA);
            aNotB.notB(skThetaB);
            result = aNotB.getResult(false);
            results.check((CompactSketch<DoubleSummary>)result);
            result = aNotB.getResult(true);
            results.check((CompactSketch<DoubleSummary>)result);
        }
    }

    private static UpdatableSketch<Double, DoubleSummary> buildUpdatableTuple() {
        return new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(mode)).build();
    }

    private static UpdateSketch buildUpdateTheta() {
        return new UpdateSketchBuilder().build();
    }

    @Test
    public void aNotBNullEmptyCombinations() {
        AnotB aNotB = new AnotB();
        CompactSketch result = aNotB.getResult(true);
        this.results.set(0, true, 0.0, 0.0, 0.0).check((CompactSketch<DoubleSummary>)result);
        UpdatableSketch<Double, DoubleSummary> sketch = AdoubleAnotBTest.buildUpdatableTuple();
        UpdateSketch skTheta = AdoubleAnotBTest.buildUpdateTheta();
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, null, null, null, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, sketch, null, null, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, null, sketch, null, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, sketch, sketch, null, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, null, null, (org.apache.datasketches.theta.Sketch)skTheta, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, sketch, null, (org.apache.datasketches.theta.Sketch)skTheta, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, null, sketch, (org.apache.datasketches.theta.Sketch)skTheta, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, sketch, sketch, (org.apache.datasketches.theta.Sketch)skTheta, this.results);
    }

    @Test
    public void aNotBCheckDoubleSetAs() {
        UpdatableSketch<Double, DoubleSummary> skA = AdoubleAnotBTest.buildUpdatableTuple();
        skA.update(1L, (Object)1.0);
        skA.update(2L, (Object)1.0);
        UpdatableSketch<Double, DoubleSummary> skA2 = AdoubleAnotBTest.buildUpdatableTuple();
        AnotB aNotB = new AnotB();
        aNotB.setA(skA);
        Assert.assertEquals((boolean)aNotB.getResult(false).isEmpty(), (boolean)false);
        aNotB.setA(skA2);
        Assert.assertEquals((boolean)aNotB.getResult(false).isEmpty(), (boolean)true);
    }

    @Test
    public void aNotBEmptyExact() {
        UpdatableSketch<Double, DoubleSummary> sketchA = AdoubleAnotBTest.buildUpdatableTuple();
        UpdatableSketch<Double, DoubleSummary> sketchB = AdoubleAnotBTest.buildUpdatableTuple();
        sketchB.update(1L, (Object)1.0);
        sketchB.update(2L, (Object)1.0);
        UpdateSketch skThetaB = AdoubleAnotBTest.buildUpdateTheta();
        skThetaB.update(1L);
        skThetaB.update(2L);
        AnotB aNotB = new AnotB();
        this.results.set(0, true, 0.0, 0.0, 0.0);
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, sketchA, sketchB, (org.apache.datasketches.theta.Sketch)skThetaB, this.results);
    }

    @Test
    public void aNotBExactEmpty() {
        UpdatableSketch<Double, DoubleSummary> sketchA = AdoubleAnotBTest.buildUpdatableTuple();
        sketchA.update(1L, (Object)1.0);
        sketchA.update(2L, (Object)1.0);
        UpdatableSketch<Double, DoubleSummary> sketchB = AdoubleAnotBTest.buildUpdatableTuple();
        UpdateSketch skThetaB = AdoubleAnotBTest.buildUpdateTheta();
        AnotB aNotB = new AnotB();
        this.results.set(2, false, 2.0, 0.0, 1.0);
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, sketchA, sketchB, (org.apache.datasketches.theta.Sketch)skThetaB, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, (Sketch<DoubleSummary>)sketchA.compact(), (Sketch<DoubleSummary>)sketchB.compact(), (org.apache.datasketches.theta.Sketch)skThetaB.compact(), this.results);
    }

    @Test
    public void aNotBExactOverlap() {
        UpdatableSketch<Double, DoubleSummary> sketchA = AdoubleAnotBTest.buildUpdatableTuple();
        sketchA.update(1L, (Object)1.0);
        sketchA.update(1L, (Object)1.0);
        sketchA.update(2L, (Object)1.0);
        sketchA.update(2L, (Object)1.0);
        UpdatableSketch<Double, DoubleSummary> sketchB = AdoubleAnotBTest.buildUpdatableTuple();
        sketchB.update(2L, (Object)1.0);
        sketchB.update(2L, (Object)1.0);
        sketchB.update(3L, (Object)1.0);
        sketchB.update(3L, (Object)1.0);
        UpdateSketch skThetaB = AdoubleAnotBTest.buildUpdateTheta();
        skThetaB.update(2L);
        skThetaB.update(3L);
        AnotB aNotB = new AnotB();
        this.results.set(1, false, 1.0, 0.0, 2.0);
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, sketchA, sketchB, (org.apache.datasketches.theta.Sketch)skThetaB, this.results);
    }

    @Test
    public void aNotBEstimationOverlap() {
        UpdatableSketch<Double, DoubleSummary> sketchA = AdoubleAnotBTest.buildUpdatableTuple();
        for (int i = 0; i < 8192; ++i) {
            sketchA.update((long)i, (Object)1.0);
        }
        UpdatableSketch<Double, DoubleSummary> sketchB = AdoubleAnotBTest.buildUpdatableTuple();
        for (int i = 0; i < 4096; ++i) {
            sketchB.update((long)i, (Object)1.0);
        }
        UpdateSketch skThetaB = AdoubleAnotBTest.buildUpdateTheta();
        for (int i = 0; i < 4096; ++i) {
            skThetaB.update((long)i);
        }
        AnotB aNotB = new AnotB();
        this.results.set(2123, false, 4096.0, 0.03, 1.0);
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, sketchA, sketchB, (org.apache.datasketches.theta.Sketch)skThetaB, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, (Sketch<DoubleSummary>)sketchA.compact(), (Sketch<DoubleSummary>)sketchB.compact(), (org.apache.datasketches.theta.Sketch)skThetaB.compact(), this.results);
    }

    @Test
    public void aNotBEstimationOverlapLargeB() {
        UpdatableSketch<Double, DoubleSummary> sketchA = AdoubleAnotBTest.buildUpdatableTuple();
        for (int i = 0; i < 10000; ++i) {
            sketchA.update((long)i, (Object)1.0);
        }
        UpdatableSketch<Double, DoubleSummary> sketchB = AdoubleAnotBTest.buildUpdatableTuple();
        for (int i = 0; i < 100000; ++i) {
            sketchB.update((long)(i + 8000), (Object)1.0);
        }
        UpdateSketch skThetaB = AdoubleAnotBTest.buildUpdateTheta();
        for (int i = 0; i < 100000; ++i) {
            skThetaB.update((long)(i + 8000));
        }
        int expected = 8000;
        AnotB aNotB = new AnotB();
        this.results.set(376, false, 8000.0, 0.1, 1.0);
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, sketchA, sketchB, (org.apache.datasketches.theta.Sketch)skThetaB, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((AnotB<DoubleSummary>)aNotB, (Sketch<DoubleSummary>)sketchA.compact(), (Sketch<DoubleSummary>)sketchB.compact(), (org.apache.datasketches.theta.Sketch)skThetaB.compact(), this.results);
    }

    private static class Results {
        private int retEnt = 0;
        private boolean empty = true;
        private double expect = 0.0;
        private double tol = 0.0;
        private double sum = 0.0;

        Results() {
        }

        Results set(int retEnt, boolean empty, double expect, double tol, double sum) {
            this.retEnt = retEnt;
            this.empty = empty;
            this.expect = expect;
            this.tol = tol;
            this.sum = sum;
            return this;
        }

        void check(CompactSketch<DoubleSummary> result) {
            Assert.assertEquals((int)result.getRetainedEntries(), (int)this.retEnt);
            Assert.assertEquals((boolean)result.isEmpty(), (boolean)this.empty);
            if (result.getTheta() < 1.0) {
                double est = result.getEstimate();
                Assert.assertEquals((double)est, (double)this.expect, (double)(this.expect * this.tol));
                Assert.assertTrue((result.getUpperBound(1) > est ? 1 : 0) != 0);
                Assert.assertTrue((result.getLowerBound(1) <= est ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((double)result.getEstimate(), (double)this.expect, (double)0.0);
                Assert.assertEquals((double)result.getUpperBound(1), (double)this.expect, (double)0.0);
                Assert.assertEquals((double)result.getLowerBound(1), (double)this.expect, (double)0.0);
            }
            TupleSketchIterator it = result.iterator();
            while (it.next()) {
                Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)this.sum);
            }
        }
    }
}

