package org.apache.torque.templates.platform;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.SizedForBitDataSqlType;
import org.apache.torque.templates.typemapping.SqlType;

import java.util.Arrays;

/**
 * Derby Platform implementation.
 *
 * @author <a href="mailto:johnnymac@tiscali.be">Johnny Macchione</a>
 * @author <a href="mailto:Monroe@DukeCE.com">Greg Monroe</a>
 * @version $Id: PlatformDerbyImpl.java 1896195 2021-12-20 17:41:20Z gk $
 */
public class PlatformDerbyImpl extends PlatformDefaultImpl
{

    /**
     * Default constructor.
     */
    public PlatformDerbyImpl()
    {
        super();
        initialize();
    }

    /**
     * Initializes db specific domain mapping.
     */
    private void initialize()
    {
        setSchemaTypeToSqlTypeMapping(
                SchemaType.LONGVARCHAR,
                new SqlType("LONG VARCHAR"));
        setSchemaTypeToSqlTypeMapping(
                SchemaType.VARBINARY,
                new SizedForBitDataSqlType("VARCHAR", "32672"));
        setSchemaTypeToSqlTypeMapping(
                SchemaType.BINARY,
                new SizedForBitDataSqlType("CHAR", "1"));
        setSchemaTypeToSqlTypeMapping(
                SchemaType.LONGVARBINARY,
                new SqlType("LONG VARCHAR FOR BIT DATA"));
        setSchemaTypeToSqlTypeMapping(
                SchemaType.LONGVARCHAR,
                new SqlType("LONG VARCHAR"));
        setSchemaTypeToSqlTypeMapping(
                SchemaType.TINYINT,
                new SqlType("SMALLINT"));
    }

    /**
     * @see org.apache.torque.templates.platform.PlatformDefaultImpl#getAutoIncrement()
     */
    @Override
    public String getAutoIncrement()
    {
        return "GENERATED BY DEFAULT AS IDENTITY";
    }

    /**
     * @see org.apache.torque.templates.platform.PlatformDefaultImpl#hasScale(java.lang.String)
     */
    @Override
    public boolean hasScale(String sqlType)
    {
        return "NUMERIC".equals(sqlType) || "DECIMAL".equals(sqlType);
    }

    /**
     * @see org.apache.torque.templates.platform.PlatformDefaultImpl#hasSize(java.lang.String)
     */
    @Override
    public boolean hasSize(String sqlType)
    {
        return Arrays.asList(
                "NUMERIC", "DECIMAL", "VARCHAR", "CHAR", "BINARY",
                        "VARBINARY", "BLOB", "CLOB")
                .contains(sqlType);
    }

    @Override
    protected boolean escapeBackslashes()
    {
        return false;
    }
}
