/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.engine;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.Charsets;
import org.apache.directory.api.dsmlv2.DsmlDecorator;
import org.apache.directory.api.dsmlv2.Dsmlv2Parser;
import org.apache.directory.api.dsmlv2.ParserUtils;
import org.apache.directory.api.dsmlv2.request.BatchRequestDsml;
import org.apache.directory.api.dsmlv2.request.Dsmlv2Grammar;
import org.apache.directory.api.dsmlv2.response.AddResponseDsml;
import org.apache.directory.api.dsmlv2.response.BatchResponseDsml;
import org.apache.directory.api.dsmlv2.response.BindResponseDsml;
import org.apache.directory.api.dsmlv2.response.CompareResponseDsml;
import org.apache.directory.api.dsmlv2.response.DelResponseDsml;
import org.apache.directory.api.dsmlv2.response.ErrorResponse;
import org.apache.directory.api.dsmlv2.response.ExtendedResponseDsml;
import org.apache.directory.api.dsmlv2.response.ModDNResponseDsml;
import org.apache.directory.api.dsmlv2.response.ModifyResponseDsml;
import org.apache.directory.api.dsmlv2.response.SearchResponseDsml;
import org.apache.directory.api.dsmlv2.response.SearchResultDoneDsml;
import org.apache.directory.api.dsmlv2.response.SearchResultEntryDsml;
import org.apache.directory.api.dsmlv2.response.SearchResultReferenceDsml;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.AbandonRequest;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindRequestImpl;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.CompareResponse;
import org.apache.directory.api.ldap.model.message.DeleteRequest;
import org.apache.directory.api.ldap.model.message.DeleteResponse;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.Request;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public class Dsmlv2Engine {
    protected String user;
    protected String password;
    protected LdapConnection connection;
    protected Dsmlv2Parser parser;
    protected boolean continueOnError;
    protected boolean exit = false;
    protected BatchRequestDsml batchRequest;
    protected BatchResponseDsml batchResponse = new BatchResponseDsml();
    protected Dsmlv2Grammar grammar = new Dsmlv2Grammar();
    protected boolean generateSoapResp = false;
    private static final Logger LOG = LoggerFactory.getLogger(Dsmlv2Engine.class);
    private static final String BODY_ENVELOPE = "</Body></Envelope>";

    public Dsmlv2Engine(String host, int port, String user, String password) {
        this.user = user;
        this.password = password;
        this.connection = new LdapNetworkConnection(host, port);
    }

    public Dsmlv2Engine(LdapConnection connection, String user, String password) {
        this.user = user;
        this.password = password;
        this.connection = connection;
    }

    public String processDSML(String dsmlInput) throws XmlPullParserException {
        this.parser = new Dsmlv2Parser(this.grammar);
        this.parser.setInput(dsmlInput);
        return this.processDSML();
    }

    public String processDSMLFile(String fileName) throws XmlPullParserException, IOException {
        this.parser = new Dsmlv2Parser(this.grammar);
        this.parser.setInputFile(fileName);
        return this.processDSML();
    }

    public void processDSMLFile(File file, OutputStream respStream) throws Exception {
        this.parser = new Dsmlv2Parser(this.grammar);
        this.parser.setInputFile(file.getAbsolutePath());
        this.processDSML(respStream);
    }

    public void processDSML(InputStream inputStream, OutputStream out) throws Exception {
        this.processDSML(inputStream, "UTF-8", out);
    }

    public void processDSML(InputStream inputStream, String inputEncoding, OutputStream out) throws Exception {
        this.parser = new Dsmlv2Parser(this.grammar);
        this.parser.setInput(inputStream, inputEncoding);
        this.processDSML(out);
    }

    private String processDSML() {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            this.processDSML(byteOut);
            return new String(byteOut.toByteArray(), Charsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_02000_FAILED_PROCESSING_DSML, (Object[])new Object[0]), (Throwable)e);
            return null;
        }
    }

    protected void processDSML(OutputStream outStream) throws IOException {
        BufferedWriter respWriter = null;
        if (outStream != null) {
            respWriter = new BufferedWriter(new OutputStreamWriter(outStream, StandardCharsets.UTF_8));
            if (this.generateSoapResp) {
                respWriter.write("<Envelope ");
                Namespace soapNs = new Namespace(null, "http://www.w3.org/2001/12/soap-envelope");
                soapNs.write((Writer)respWriter);
                respWriter.write("><Body>");
            }
        }
        try {
            this.bind(1);
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(I18n.msg((I18n)I18n.MSG_02002_FAILED_TO_BIND, (Object[])new Object[0]), (Throwable)e);
            }
            ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.COULD_NOT_CONNECT, e.getLocalizedMessage());
            this.batchResponse.addResponse((DsmlDecorator)errorResponse);
            if (respWriter != null) {
                respWriter.write(this.batchResponse.toDsml());
                if (this.generateSoapResp) {
                    respWriter.write(BODY_ENVELOPE);
                }
                respWriter.flush();
            }
            return;
        }
        try {
            this.processBatchRequest();
        }
        catch (XmlPullParserException e) {
            ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.MALFORMED_REQUEST, I18n.err((I18n)I18n.ERR_02003_LINE_COLUMN, (Object[])new Object[]{e.getLocalizedMessage(), e.getLineNumber(), e.getColumnNumber()}));
            this.batchResponse.addResponse((DsmlDecorator)errorResponse);
            if (respWriter != null) {
                respWriter.write(this.batchResponse.toDsml());
                if (this.generateSoapResp) {
                    respWriter.write(BODY_ENVELOPE);
                }
                respWriter.flush();
            }
            return;
        }
        String batchResponseTag = null;
        if (respWriter != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<batchResponse ");
            sb.append(ParserUtils.DSML_NAMESPACE.asXML());
            sb.append(" ");
            sb.append(ParserUtils.XSD_NAMESPACE.asXML());
            sb.append(" ");
            sb.append(ParserUtils.XSI_NAMESPACE.asXML());
            sb.append(" requestID=\"");
            sb.append(this.batchRequest.getRequestID());
            sb.append("\">");
            batchResponseTag = sb.toString();
        }
        DsmlDecorator request = null;
        try {
            request = this.parser.getNextRequest();
        }
        catch (XmlPullParserException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(I18n.msg((I18n)I18n.MSG_02000_FAILED_GETTING_NEXT_REQUEST, (Object[])new Object[0]), (Throwable)e);
            }
            int reqId = 0;
            ErrorResponse errorResponse = new ErrorResponse(reqId, ErrorResponse.ErrorResponseType.MALFORMED_REQUEST, I18n.err((I18n)I18n.ERR_02003_LINE_COLUMN, (Object[])new Object[]{e.getLocalizedMessage(), e.getLineNumber(), e.getColumnNumber()}));
            this.batchResponse.addResponse((DsmlDecorator)errorResponse);
            if (respWriter != null) {
                respWriter.write(this.batchResponse.toDsml());
                if (this.generateSoapResp) {
                    respWriter.write(BODY_ENVELOPE);
                }
                respWriter.flush();
            }
            return;
        }
        if (respWriter != null) {
            respWriter.write(batchResponseTag);
        }
        while (request != null) {
            if (this.batchRequest.getProcessing().equals((Object)BatchRequestDsml.Processing.PARALLEL) && this.batchRequest.getResponseOrder().equals((Object)BatchRequestDsml.ResponseOrder.UNORDERED) && ((Request)request.getDecorated()).getMessageId() <= 0) {
                ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.MALFORMED_REQUEST, I18n.err((I18n)I18n.ERR_02004_MISSING_REQUEST_ID, (Object[])new Object[0]));
                if (respWriter != null) {
                    this.writeResponse(respWriter, (DsmlDecorator<?>)errorResponse);
                    break;
                }
                this.batchResponse.addResponse((DsmlDecorator)errorResponse);
                break;
            }
            try {
                this.processRequest((DsmlDecorator<? extends Request>)request, respWriter);
            }
            catch (Exception e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn(I18n.msg((I18n)I18n.MSG_02001_FAILED_PROCESSING_REQUEST, (Object[])new Object[0]), (Throwable)e);
                }
                ErrorResponse errorResponse = new ErrorResponse(((Request)request.getDecorated()).getMessageId(), ErrorResponse.ErrorResponseType.GATEWAY_INTERNAL_ERROR, I18n.err((I18n)I18n.ERR_02005_INTERNAL_ERROR, (Object[])new Object[]{e.getMessage()}));
                if (respWriter != null) {
                    this.writeResponse(respWriter, (DsmlDecorator<?>)errorResponse);
                    break;
                }
                this.batchResponse.addResponse((DsmlDecorator)errorResponse);
                break;
            }
            if (this.exit) break;
            try {
                request = this.parser.getNextRequest();
            }
            catch (XmlPullParserException e) {
                ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.MALFORMED_REQUEST, I18n.err((I18n)I18n.ERR_02003_LINE_COLUMN, (Object[])new Object[]{e.getLocalizedMessage(), e.getLineNumber(), e.getColumnNumber()}));
                if (respWriter != null) {
                    this.writeResponse(respWriter, (DsmlDecorator<?>)errorResponse);
                    break;
                }
                this.batchResponse.addResponse((DsmlDecorator)errorResponse);
                break;
            }
        }
        if (respWriter != null) {
            respWriter.write("</batchResponse>");
            if (this.generateSoapResp) {
                respWriter.write(BODY_ENVELOPE);
            }
            respWriter.flush();
        }
    }

    protected void writeResponse(BufferedWriter respWriter, DsmlDecorator<?> respDsml) throws IOException {
        if (respWriter != null) {
            Element xml = respDsml.toDsml(null);
            xml.write((Writer)respWriter);
        }
    }

    public boolean isGenerateSoapResp() {
        return this.generateSoapResp;
    }

    public void setGenerateSoapResp(boolean generateSoapResp) {
        this.generateSoapResp = generateSoapResp;
    }

    public BatchResponseDsml getBatchResponse() {
        return this.batchResponse;
    }

    public LdapConnection getConnection() {
        return this.connection;
    }

    protected void processRequest(DsmlDecorator<? extends Request> request, BufferedWriter respWriter) throws Exception {
        ResultCodeEnum resultCode = null;
        switch (((Request)request.getDecorated()).getType()) {
            case ABANDON_REQUEST: {
                this.connection.abandon((AbandonRequest)request);
                return;
            }
            case ADD_REQUEST: {
                AddResponse response = this.connection.add((AddRequest)request);
                resultCode = response.getLdapResult().getResultCode();
                AddResponseDsml addResponseDsml = new AddResponseDsml(this.connection.getCodecService(), response);
                this.writeResponse(respWriter, (DsmlDecorator<?>)addResponseDsml);
                break;
            }
            case BIND_REQUEST: {
                BindResponse bindResponse = this.connection.bind((BindRequest)request);
                resultCode = bindResponse.getLdapResult().getResultCode();
                BindResponseDsml authResponseDsml = new BindResponseDsml(this.connection.getCodecService(), bindResponse);
                this.writeResponse(respWriter, (DsmlDecorator<?>)authResponseDsml);
                break;
            }
            case COMPARE_REQUEST: {
                CompareResponse compareResponse = this.connection.compare((CompareRequest)request);
                resultCode = compareResponse.getLdapResult().getResultCode();
                CompareResponseDsml compareResponseDsml = new CompareResponseDsml(this.connection.getCodecService(), compareResponse);
                this.writeResponse(respWriter, (DsmlDecorator<?>)compareResponseDsml);
                break;
            }
            case DEL_REQUEST: {
                DeleteResponse delResponse = this.connection.delete((DeleteRequest)request);
                resultCode = delResponse.getLdapResult().getResultCode();
                DelResponseDsml delResponseDsml = new DelResponseDsml(this.connection.getCodecService(), delResponse);
                this.writeResponse(respWriter, (DsmlDecorator<?>)delResponseDsml);
                break;
            }
            case EXTENDED_REQUEST: {
                ExtendedResponse extendedResponse = this.connection.extended((ExtendedRequest)request);
                resultCode = extendedResponse.getLdapResult().getResultCode();
                ExtendedResponseDsml extendedResponseDsml = new ExtendedResponseDsml(this.connection.getCodecService(), extendedResponse);
                this.writeResponse(respWriter, (DsmlDecorator<?>)extendedResponseDsml);
                break;
            }
            case MODIFY_REQUEST: {
                ModifyResponse modifyResponse = this.connection.modify((ModifyRequest)request);
                resultCode = modifyResponse.getLdapResult().getResultCode();
                ModifyResponseDsml modifyResponseDsml = new ModifyResponseDsml(this.connection.getCodecService(), modifyResponse);
                this.writeResponse(respWriter, (DsmlDecorator<?>)modifyResponseDsml);
                break;
            }
            case MODIFYDN_REQUEST: {
                ModifyDnResponse modifyDnResponse = this.connection.modifyDn((ModifyDnRequest)request);
                resultCode = modifyDnResponse.getLdapResult().getResultCode();
                ModDNResponseDsml modDNResponseDsml = new ModDNResponseDsml(this.connection.getCodecService(), modifyDnResponse);
                this.writeResponse(respWriter, (DsmlDecorator<?>)modDNResponseDsml);
                break;
            }
            case SEARCH_REQUEST: {
                SearchCursor searchResponses = this.connection.search((SearchRequest)request);
                SearchResponseDsml searchResponseDsml = new SearchResponseDsml(this.connection.getCodecService());
                if (respWriter != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("<searchResponse");
                    if (((Request)request.getDecorated()).getMessageId() > 0) {
                        sb.append(" requestID=\"");
                        sb.append(((Request)request.getDecorated()).getMessageId());
                        sb.append('\"');
                    }
                    sb.append('>');
                    respWriter.write(sb.toString());
                }
                while (searchResponses.next()) {
                    Response searchResponse = (Response)searchResponses.get();
                    if (searchResponse.getType() == MessageTypeEnum.SEARCH_RESULT_ENTRY) {
                        SearchResultEntry searchResultEntry = (SearchResultEntry)searchResponse;
                        SearchResultEntryDsml searchResultEntryDsml = new SearchResultEntryDsml(this.connection.getCodecService(), searchResultEntry);
                        searchResponseDsml = new SearchResponseDsml(this.connection.getCodecService(), (Message)searchResultEntryDsml);
                        if (respWriter != null) {
                            this.writeResponse(respWriter, (DsmlDecorator<?>)searchResultEntryDsml);
                            continue;
                        }
                        searchResponseDsml.addResponse((DsmlDecorator)searchResultEntryDsml);
                        continue;
                    }
                    if (searchResponse.getType() != MessageTypeEnum.SEARCH_RESULT_REFERENCE) continue;
                    SearchResultReference searchResultReference = (SearchResultReference)searchResponse;
                    SearchResultReferenceDsml searchResultReferenceDsml = new SearchResultReferenceDsml(this.connection.getCodecService(), searchResultReference);
                    searchResponseDsml = new SearchResponseDsml(this.connection.getCodecService(), (Message)searchResultReferenceDsml);
                    if (respWriter != null) {
                        this.writeResponse(respWriter, (DsmlDecorator<?>)searchResultReferenceDsml);
                        continue;
                    }
                    searchResponseDsml.addResponse((DsmlDecorator)searchResultReferenceDsml);
                }
                SearchResultDone srDone = searchResponses.getSearchResultDone();
                if (srDone == null) break;
                resultCode = srDone.getLdapResult().getResultCode();
                SearchResultDoneDsml srdDsml = new SearchResultDoneDsml(this.connection.getCodecService(), srDone);
                if (respWriter != null) {
                    this.writeResponse(respWriter, (DsmlDecorator<?>)srdDsml);
                    respWriter.write("</searchResponse>");
                    break;
                }
                searchResponseDsml.addResponse((DsmlDecorator)srdDsml);
                this.batchResponse.addResponse((DsmlDecorator)searchResponseDsml);
                break;
            }
            case UNBIND_REQUEST: {
                this.connection.unBind();
                break;
            }
            default: {
                throw new IllegalStateException(I18n.err((I18n)I18n.ERR_02001_UNEXPECTED_REQUEST_TYPE, (Object[])new Object[]{((Request)request.getDecorated()).getType()}));
            }
        }
        if (!this.continueOnError && resultCode != null && resultCode != ResultCodeEnum.SUCCESS && resultCode != ResultCodeEnum.COMPARE_TRUE && resultCode != ResultCodeEnum.COMPARE_FALSE && resultCode != ResultCodeEnum.REFERRAL) {
            this.exit = true;
        }
    }

    protected void processBatchRequest() throws XmlPullParserException {
        this.parser.parseBatchRequest();
        this.batchRequest = this.parser.getBatchRequest();
        if (BatchRequestDsml.OnError.RESUME.equals((Object)this.batchRequest.getOnError())) {
            this.continueOnError = true;
        } else if (BatchRequestDsml.OnError.EXIT.equals((Object)this.batchRequest.getOnError())) {
            this.continueOnError = false;
        }
        if (this.batchRequest.getRequestID() != 0 && this.batchResponse != null) {
            this.batchResponse.setRequestID(this.batchRequest.getRequestID());
        }
    }

    protected void bind(int messageId) throws LdapException, IOException {
        if (this.connection != null && this.connection.isAuthenticated()) {
            return;
        }
        if (this.connection == null) {
            throw new IOException(I18n.err((I18n)I18n.ERR_02002_MISSING_CONNECTION_TO_BIND, (Object[])new Object[0]));
        }
        BindRequestImpl bindRequest = new BindRequestImpl();
        bindRequest.setSimple(true);
        bindRequest.setCredentials(Strings.getBytesUtf8((String)this.password));
        bindRequest.setName(this.user);
        bindRequest.setVersion3(true);
        bindRequest.setMessageId(messageId);
        BindResponse bindResponse = this.connection.bind((BindRequest)bindRequest);
        if (bindResponse.getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS && LOG.isWarnEnabled()) {
            LOG.warn(I18n.msg((I18n)I18n.MSG_02003_ERROR, (Object[])new Object[]{bindResponse.getLdapResult().getDiagnosticMessage()}));
        }
    }
}

