/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2;

import org.apache.directory.api.dsmlv2.DsmlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.Control;
import org.dom4j.Element;

public class DsmlControl<C extends Control>
implements Control,
DsmlDecorator<C> {
    private C decorated;
    protected byte[] value;
    private LdapApiService codec;

    public DsmlControl(LdapApiService codec, C decorated) {
        this.codec = codec;
        this.decorated = decorated;
    }

    public LdapApiService getCodecService() {
        return this.codec;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        if (value != null) {
            byte[] copy = new byte[value.length];
            System.arraycopy(value, 0, copy, 0, value.length);
            this.value = copy;
        } else {
            this.value = null;
        }
    }

    @Override
    public String getOid() {
        return this.decorated.getOid();
    }

    @Override
    public boolean isCritical() {
        return this.decorated.isCritical();
    }

    @Override
    public void setCritical(boolean isCritical) {
        this.decorated.setCritical(isCritical);
    }

    @Override
    public Element toDsml(Element root) {
        return null;
    }

    @Override
    public C getDecorated() {
        return this.decorated;
    }
}

