#!/usr/bin/env bash
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

set -euo pipefail

if test $# -gt 0; then
    echo "$0 does not accept arguments" >&2
    exit 32
fi

# Supervisord is not running
if ! test -f /tmp/supervisor.sock; then
    exit 0
fi

# Check if all Hadoop services are running
FAILED=$(supervisorctl status | grep -v RUNNING || true)

if [ "$FAILED" == "" ]; then
  echo "All services are running"
  exit 0
else
  echo "Some of the services are failing: ${FAILED}"
  exit 1
fi
