// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.


suite("test_createtable_strlen") {

    def table = "test_ct_strlen"
    try {
        sql """
        create table ${table} (
            k1 CHAR, 
            K2 CHAR(10) ,  
            K3 VARCHAR , 
            K4 VARCHAR(10) ) 
            duplicate key (k1) 
            distributed by hash(k1) buckets 1 
            properties('replication_num' = '1');
        """
        
        qt_create """ desc ${table}; """ 

    } finally {
        sql """ DROP TABLE IF EXISTS ${table}; """ 
    }
    
}