/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.impl.base;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.atomos.AtomosContent;
import org.apache.felix.atomos.AtomosLayer;
import org.apache.felix.atomos.impl.base.AtomosBase;

public class AtomosStorage {
    private static final int VERSION = 1;
    private static final String ATOMOS_STORE = "atomosStore.data";
    private final AtomosBase atomos;

    public AtomosStorage(AtomosBase atomos) {
        this.atomos = atomos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadLayers(File root) throws IOException {
        this.atomos.lockWrite();
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(root, ATOMOS_STORE))));){
            this.atomos.debug("Found %s in %s", ATOMOS_STORE, root);
            int persistentVersion = in.readInt();
            if (persistentVersion > 1) {
                throw new IOException("Atomos persistent version is greater than supported version: 1<" + persistentVersion);
            }
            long nextLayerId = in.readLong();
            int numLayers = in.readInt();
            if (numLayers > 1 && !this.atomos.getBootLayer().isAddLayerSupported()) {
                System.out.println("Atomos persistent layers are ignored because Atomos is not loaded as a module.");
                return;
            }
            for (int i = 0; i < numLayers; ++i) {
                this.readLayer(in);
            }
            this.atomos.nextLayerId.set(nextLayerId);
        }
        catch (FileNotFoundException e) {
            this.atomos.debug("No %s found in %s", ATOMOS_STORE, root);
        }
        finally {
            this.atomos.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveLayers(File root) throws IOException {
        File atomosStore = new File(root, ATOMOS_STORE);
        this.atomos.lockRead();
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(atomosStore)));){
            out.writeInt(1);
            out.writeLong(this.atomos.nextLayerId.get());
            List<AtomosBase.AtomosLayerBase> writeOrder = this.getLayerWriteOrder(this.atomos.getBootLayer(), new HashSet<AtomosLayer>(), new ArrayList<AtomosBase.AtomosLayerBase>());
            out.writeInt(writeOrder.size());
            for (AtomosBase.AtomosLayerBase layer : writeOrder) {
                this.writeLayer(layer, out);
            }
        }
        finally {
            this.atomos.unlockRead();
        }
    }

    private List<AtomosBase.AtomosLayerBase> getLayerWriteOrder(AtomosLayer layer, Set<AtomosLayer> visited, List<AtomosBase.AtomosLayerBase> result) {
        if (!visited.add(layer)) {
            return result;
        }
        for (AtomosLayer parent : layer.getParents()) {
            this.getLayerWriteOrder(parent, visited, result);
        }
        result.add((AtomosBase.AtomosLayerBase)layer);
        for (AtomosLayer child : layer.getChildren()) {
            this.getLayerWriteOrder(child, visited, result);
        }
        return result;
    }

    private void readLayer(DataInputStream in) throws IOException {
        String name = in.readUTF();
        long id = in.readLong();
        AtomosLayer.LoaderType loaderType = AtomosLayer.LoaderType.valueOf(in.readUTF());
        this.atomos.debug("Loading layer %s %s %s", new Object[]{name, id, loaderType});
        int numPaths = in.readInt();
        Path[] paths = new Path[numPaths];
        for (int i = 0; i < numPaths; ++i) {
            String sURI = in.readUTF();
            try {
                URI uri = new URI(sURI);
                paths[i] = new File(uri).toPath();
                continue;
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        int numParents = in.readInt();
        ArrayList<AtomosLayer> parents = new ArrayList<AtomosLayer>();
        for (int i = 0; i < numParents; ++i) {
            long parentId = in.readLong();
            AtomosBase.AtomosLayerBase parent = this.atomos.getById(parentId);
            if (parent == null) {
                throw new IllegalArgumentException("Missing parent with id: " + parentId);
            }
            parents.add(parent);
        }
        if (this.atomos.getById(id) == null) {
            try {
                this.atomos.addLayer(parents, name, id, loaderType, paths);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error adding persistent layer: " + e.getMessage());
            }
        }
        int numBundles = in.readInt();
        for (int i = 0; i < numBundles; ++i) {
            String atomosLocation = in.readUTF();
            this.atomos.debug("Found Atomos location %s", atomosLocation);
            if (!in.readBoolean()) continue;
            String connectLocation = in.readUTF();
            this.atomos.debug("Found connected location %s", connectLocation);
            if ("System Bundle".equals(connectLocation)) continue;
            AtomosBase.AtomosLayerBase.AtomosContentBase atomosContent = this.atomos.getByAtomosLocation(atomosLocation);
            if (atomosContent != null) {
                this.atomos.connectAtomosContent(connectLocation, atomosContent);
                continue;
            }
            this.atomos.debug("Unable to find atomos content for location %s", atomosLocation);
        }
    }

    private void writeLayer(AtomosBase.AtomosLayerBase layer, DataOutputStream out) throws IOException {
        out.writeUTF(layer.getName());
        out.writeLong(layer.getId());
        out.writeUTF(layer.getLoaderType().toString());
        List<Path> paths = layer.getPaths();
        out.writeInt(paths.size());
        for (Path path : paths) {
            out.writeUTF(path.toUri().toString());
        }
        List<AtomosLayer> parents = layer.getParents();
        out.writeInt(parents.size());
        for (AtomosLayer parent : parents) {
            out.writeLong(parent.getId());
        }
        Set<AtomosContent> set = layer.getAtomosContents();
        out.writeInt(set.size());
        for (AtomosContent content : set) {
            String atomosLocation = content.getAtomosLocation();
            out.writeUTF(atomosLocation);
            String connectLocation = content.getConnectLocation();
            out.writeBoolean(connectLocation != null);
            if (connectLocation == null) continue;
            out.writeUTF(connectLocation);
        }
    }
}

