/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import org.cybergarage.util.Debug;

public class SSDP {
    private static final String SSDP_PORT = "cyberdomo.ssdp.port";
    private static final String SSDP_MX = "cyberdomo.ssdp.mx";
    private static final String SSDP_BUFFER_SIZE = "cyberdomo.ssdp.buffersize";
    public static int PORT = 1900;
    public static int DEFAULT_MSEARCH_MX = 5;
    public static int RECV_MESSAGE_BUFSIZE = 2048;
    public static final String ADDRESS = "239.255.255.250";
    public static final String IPV6_LINK_LOCAL_ADDRESS = "FF02::C";
    public static final String IPV6_SUBNET_ADDRESS = "FF03::C";
    public static final String IPV6_ADMINISTRATIVE_ADDRESS = "FF04::C";
    public static final String IPV6_SITE_LOCAL_ADDRESS = "FF05::C";
    public static final String IPV6_GLOBAL_ADDRESS = "FF0E::C";
    private static String IPV6_ADDRESS;

    public static final void setIPv6Address(String addr) {
        IPV6_ADDRESS = addr;
    }

    public static final String getIPv6Address() {
        return IPV6_ADDRESS;
    }

    public static final int getLeaseTime(String cacheCont) {
        int mx = 0;
        int maxAgeIdx = cacheCont.indexOf("max-age");
        if (maxAgeIdx >= 0) {
            int endIdx = cacheCont.indexOf(44, maxAgeIdx);
            if (endIdx < 0) {
                endIdx = cacheCont.length();
            }
            try {
                maxAgeIdx = cacheCont.indexOf("=", maxAgeIdx);
                String mxStr = cacheCont.substring(maxAgeIdx + 1, endIdx).trim();
                mx = Integer.parseInt(mxStr);
            }
            catch (Exception e) {
                Debug.warning(e);
            }
        }
        return mx;
    }

    public static final void setGlobalMSearchMX(int mx) {
        DEFAULT_MSEARCH_MX = mx;
    }

    public static final int getGlobalMSearchMX() {
        return DEFAULT_MSEARCH_MX;
    }

    static {
        SSDP.setIPv6Address(IPV6_LINK_LOCAL_ADDRESS);
        PORT = 1900;
        String portProperty = System.getProperty(SSDP_PORT);
        if (portProperty != null) {
            try {
                int port = Integer.parseInt(portProperty);
                if (port > 1023 && port < 49151) {
                    PORT = port;
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        DEFAULT_MSEARCH_MX = 5;
        String mxProperty = System.getProperty(SSDP_MX);
        if (mxProperty != null) {
            try {
                int mx = Integer.parseInt(mxProperty);
                if (mx > 0 && mx < 300) {
                    DEFAULT_MSEARCH_MX = mx;
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        RECV_MESSAGE_BUFSIZE = 2048;
        String bufSizeProperty = System.getProperty(SSDP_BUFFER_SIZE);
        if (bufSizeProperty != null) {
            try {
                int bufferSize = Integer.parseInt(bufSizeProperty);
                if (bufferSize > 512 && bufferSize < 65536) {
                    RECV_MESSAGE_BUFSIZE = bufferSize;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

