/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.apache.felix.useradmin.RoleFactory;
import org.apache.felix.useradmin.mongodb.KeyCodec;
import org.apache.felix.useradmin.mongodb.RoleProvider;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;

final class MongoSerializerHelper {
    static final String TYPE = "type";
    static final String NAME = "name";
    static final String PROPERTIES = "properties";
    static final String CREDENTIALS = "credentials";
    static final String MEMBERS = "members";
    static final String REQUIRED_MEMBERS = "requiredMembers";
    static final String SET = "$set";
    private final RoleProvider m_roleProvider;

    public MongoSerializerHelper(RoleProvider roleProvider) {
        this.m_roleProvider = roleProvider;
    }

    public Role deserialize(DBObject object) {
        int type = (Integer)object.get(TYPE);
        String name = (String)object.get(NAME);
        Role result = RoleFactory.createRole((int)type, (String)name);
        this.deserializeDictionary(result.getProperties(), (DBObject)object.get(PROPERTIES));
        if (2 == type || 1 == type) {
            this.deserializeDictionary(((User)result).getCredentials(), (DBObject)object.get(CREDENTIALS));
            if (2 == type) {
                for (Role member : this.getRoles((BasicDBList)object.get(MEMBERS))) {
                    ((Group)result).addMember(member);
                }
                for (Role member : this.getRoles((BasicDBList)object.get(REQUIRED_MEMBERS))) {
                    ((Group)result).addRequiredMember(member);
                }
            }
        }
        return result;
    }

    public DBObject serialize(Role role) {
        BasicDBObject data = new BasicDBObject();
        int type = role.getType();
        data.put(TYPE, (Object)type);
        data.put(NAME, (Object)role.getName());
        data.put(PROPERTIES, (Object)this.serializeDictionary(role.getProperties()));
        if (2 == type || 1 == type) {
            data.put(CREDENTIALS, (Object)this.serializeDictionary(((User)role).getCredentials()));
            if (2 == type) {
                data.put(MEMBERS, this.getRoleNames(((Group)role).getMembers()));
                data.put(REQUIRED_MEMBERS, this.getRoleNames(((Group)role).getRequiredMembers()));
            }
        }
        return data;
    }

    public DBObject serialize(String roleName, int type) {
        BasicDBObject data = new BasicDBObject();
        data.put(TYPE, (Object)type);
        data.put(NAME, (Object)roleName);
        return data;
    }

    public DBObject serializeUpdate(Role role) {
        int type = role.getType();
        BasicDBObject changeSet = new BasicDBObject();
        changeSet.put(PROPERTIES, (Object)this.serializeDictionary(role.getProperties()));
        if (2 == type || 1 == type) {
            changeSet.put(CREDENTIALS, (Object)this.serializeDictionary(((User)role).getCredentials()));
            if (2 == type) {
                changeSet.put(MEMBERS, this.getRoleNames(((Group)role).getMembers()));
                changeSet.put(REQUIRED_MEMBERS, this.getRoleNames(((Group)role).getRequiredMembers()));
            }
        }
        return new BasicDBObject(SET, (Object)changeSet);
    }

    final Role findExistingMember(String name) {
        Role result = this.m_roleProvider.getRole(name);
        if (result == null) {
            throw new MongoException("No such role: " + name);
        }
        return result;
    }

    private void deserializeDictionary(Dictionary dictionary, DBObject object) {
        for (String key : object.keySet()) {
            dictionary.put(KeyCodec.decode(key), object.get(key));
        }
    }

    private List<String> getRoleNames(Role[] members) {
        ArrayList<String> result = new ArrayList<String>();
        if (members != null) {
            for (Role member : members) {
                result.add(member.getName());
            }
        }
        return result;
    }

    private List<Role> getRoles(BasicDBList list) {
        ArrayList<Role> result = new ArrayList<Role>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String memberName = (String)list.get(i);
            result.add(this.findExistingMember(memberName));
        }
        return result;
    }

    private DBObject serializeDictionary(Dictionary properties) {
        BasicDBObject result = new BasicDBObject();
        Enumeration keysEnum = properties.keys();
        while (keysEnum.hasMoreElements()) {
            String key = (String)keysEnum.nextElement();
            Object value = properties.get(key);
            result.append(KeyCodec.encode(key), value);
        }
        return result;
    }
}

