/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.forks.velocity.test;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.flex.forks.velocity.VelocityContext;
import org.apache.flex.forks.velocity.app.Velocity;
import org.apache.flex.forks.velocity.app.event.EventCartridge;
import org.apache.flex.forks.velocity.app.event.MethodExceptionEventHandler;
import org.apache.flex.forks.velocity.app.event.NullSetEventHandler;
import org.apache.flex.forks.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.flex.forks.velocity.context.Context;
import org.apache.flex.forks.velocity.exception.MethodInvocationException;
import org.apache.flex.forks.velocity.exception.ParseErrorException;
import org.apache.flex.forks.velocity.runtime.RuntimeServices;
import org.apache.flex.forks.velocity.runtime.log.LogSystem;

public class EventHandlingTestCase
extends TestCase
implements ReferenceInsertionEventHandler,
NullSetEventHandler,
MethodExceptionEventHandler,
LogSystem {
    private String logString = null;
    private boolean exceptionSwitch = true;
    private static String NO_REFERENCE_VALUE = "<no reference value>";
    private static String REFERENCE_VALUE = "<reference value>";

    public EventHandlingTestCase() {
        super("EventHandlingTestCase");
        try {
            Velocity.setProperty("runtime.log.logsystem", this);
            Velocity.init();
        }
        catch (Exception e) {
            System.err.println("Cannot setup event handling test : " + e);
            System.exit(1);
        }
    }

    public void init(RuntimeServices rs) {
    }

    public static Test suite() {
        return new EventHandlingTestCase();
    }

    public void runTest() {
        VelocityContext inner = new VelocityContext();
        EventCartridge ec = new EventCartridge();
        ec.addEventHandler(this);
        ec.attachToContext(inner);
        VelocityContext context = new VelocityContext(inner);
        context.put("name", "Velocity");
        try {
            String s = "$name";
            StringWriter w = new StringWriter();
            Velocity.evaluate((Context)context, (Writer)w, "mystring", s);
            if (!w.toString().equals(REFERENCE_VALUE)) {
                EventHandlingTestCase.fail((String)"Reference insertion test 1");
            }
            s = "$floobie";
            w = new StringWriter();
            Velocity.evaluate((Context)context, (Writer)w, "mystring", s);
            if (!w.toString().equals(NO_REFERENCE_VALUE)) {
                EventHandlingTestCase.fail((String)"Reference insertion test 2");
            }
            s = "#set($settest = $NotAReference)";
            w = new StringWriter();
            this.logString = null;
            Velocity.evaluate((Context)context, (Writer)w, "mystring", s);
            if (this.logString != null) {
                EventHandlingTestCase.fail((String)"NullSetEventHandler test 1");
            }
            s = "#set($logthis = $NotAReference)";
            w = new StringWriter();
            this.logString = null;
            Velocity.evaluate((Context)context, (Writer)w, "mystring", s);
            if (this.logString == null) {
                EventHandlingTestCase.fail((String)"NullSetEventHandler test 1");
            }
            this.exceptionSwitch = true;
            context.put("this", this);
            s = " $this.throwException()";
            w = new StringWriter();
            try {
                Velocity.evaluate((Context)context, (Writer)w, "mystring", s);
            }
            catch (MethodInvocationException mee) {
                EventHandlingTestCase.fail((String)"MethodExceptionEvent test 1");
            }
            catch (Exception e) {
                EventHandlingTestCase.fail((String)"MethodExceptionEvent test 1");
            }
            this.exceptionSwitch = false;
            s = " $this.throwException()";
            w = new StringWriter();
            try {
                Velocity.evaluate((Context)context, (Writer)w, "mystring", s);
                EventHandlingTestCase.fail((String)"MethodExceptionEvent test 2");
            }
            catch (MethodInvocationException e) {
            }
            catch (Exception e) {
                EventHandlingTestCase.fail((String)"MethodExceptionEvent test 2");
            }
        }
        catch (ParseErrorException pee) {
            EventHandlingTestCase.fail((String)("ParseErrorException" + pee));
        }
        catch (MethodInvocationException mee) {
            EventHandlingTestCase.fail((String)("MethodInvocationException" + mee));
        }
        catch (Exception e) {
            EventHandlingTestCase.fail((String)("Exception" + e));
        }
    }

    public void throwException() throws Exception {
        throw new Exception("Hello from throwException()");
    }

    public Object referenceInsert(String reference, Object value) {
        String s = null;
        if (value != null) {
            s = REFERENCE_VALUE;
        } else if (reference.equals("$floobie")) {
            s = NO_REFERENCE_VALUE;
        }
        return s;
    }

    public boolean shouldLogOnNullSet(String lhs, String rhs) {
        return !lhs.equals("$settest");
    }

    public Object methodException(Class claz, String method, Exception e) throws Exception {
        if (this.exceptionSwitch && method.equals("throwException")) {
            return "handler";
        }
        throw e;
    }

    public void logVelocityMessage(int level, String message) {
        this.logString = message;
    }
}

