/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant.launcher.contexts;

import java.io.IOException;
import org.apache.tools.ant.Project;
import org.flexunit.ant.LoggingUtil;
import org.flexunit.ant.launcher.commands.headless.XvncException;
import org.flexunit.ant.launcher.commands.headless.XvncStartCommand;
import org.flexunit.ant.launcher.commands.headless.XvncStopCommand;
import org.flexunit.ant.launcher.commands.player.PlayerCommand;
import org.flexunit.ant.launcher.contexts.ExecutionContext;

public class HeadlessContext
implements ExecutionContext {
    private PlayerCommand playerCommand;
    private int startDisplay;
    private int finalDisplay;
    private Project project;

    public HeadlessContext(int n) {
        this.startDisplay = n;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setCommand(PlayerCommand playerCommand) {
        this.playerCommand = playerCommand;
    }

    public void start() throws IOException {
        XvncStartCommand xvncStartCommand = new XvncStartCommand(this.startDisplay);
        xvncStartCommand.setProject(this.project);
        LoggingUtil.log("Starting xvnc", true);
        while (xvncStartCommand.execute() != 0) {
            LoggingUtil.log("Cannot start xnvc on :" + xvncStartCommand.getCurrentDisplay() + ", cycling ...");
            try {
                xvncStartCommand.cycle();
            }
            catch (XvncException xvncException) {
                throw new IOException(xvncException);
            }
        }
        this.finalDisplay = xvncStartCommand.getCurrentDisplay();
        this.playerCommand.setEnvironment(new String[]{"DISPLAY=:" + this.finalDisplay});
        LoggingUtil.log("Setting DISPLAY=:" + this.finalDisplay);
        this.playerCommand.prepare();
    }

    public void stop(Process process) throws IOException {
        if (process != null) {
            process.destroy();
        }
        XvncStopCommand xvncStopCommand = new XvncStopCommand(this.finalDisplay);
        xvncStopCommand.setProject(this.project);
        xvncStopCommand.execute();
    }
}

