/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.internal;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Collection;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunctionBase;
import org.apache.flink.table.runtime.operators.window.Window;
import org.apache.flink.table.runtime.operators.window.assigners.WindowAssigner;
import org.apache.flink.table.runtime.util.TimeWindowUtil;

public abstract class InternalWindowProcessFunction<K, W extends Window>
implements Serializable {
    private static final long serialVersionUID = 5191040787066951059L;
    protected final WindowAssigner<W> windowAssigner;
    protected final NamespaceAggsHandleFunctionBase<W> windowAggregator;
    protected final long allowedLateness;
    protected Context<K, W> ctx;

    protected InternalWindowProcessFunction(WindowAssigner<W> windowAssigner, NamespaceAggsHandleFunctionBase<W> windowAggregator, long allowedLateness) {
        this.windowAssigner = windowAssigner;
        this.windowAggregator = windowAggregator;
        this.allowedLateness = allowedLateness;
    }

    public void open(Context<K, W> ctx) throws Exception {
        this.ctx = ctx;
        this.windowAssigner.open(ctx);
    }

    public abstract Collection<W> assignStateNamespace(RowData var1, long var2) throws Exception;

    public abstract Collection<W> assignActualWindows(RowData var1, long var2) throws Exception;

    public abstract void prepareAggregateAccumulatorForEmit(W var1) throws Exception;

    public abstract void cleanWindowIfNeeded(W var1, long var2) throws Exception;

    public void close() throws Exception {
    }

    protected final boolean isCleanupTime(W window, long time) {
        return time == TimeWindowUtil.toEpochMillsForTimer(this.cleanupTime(window), this.ctx.getShiftTimeZone());
    }

    protected boolean isWindowLate(W window) {
        return this.windowAssigner.isEventTime() && TimeWindowUtil.toEpochMillsForTimer(this.cleanupTime(window), this.ctx.getShiftTimeZone()) <= this.ctx.currentWatermark();
    }

    private long cleanupTime(W window) {
        if (this.windowAssigner.isEventTime()) {
            long cleanupTime = ((Window)window).maxTimestamp() + this.allowedLateness;
            return cleanupTime >= ((Window)window).maxTimestamp() ? cleanupTime : Long.MAX_VALUE;
        }
        return ((Window)window).maxTimestamp();
    }

    public static interface Context<K, W extends Window> {
        public <S extends State> S getPartitionedState(StateDescriptor<S, ?> var1) throws Exception;

        public K currentKey();

        public long currentProcessingTime();

        public long currentWatermark();

        public ZoneId getShiftTimeZone();

        public RowData getWindowAccumulators(W var1) throws Exception;

        public void setWindowAccumulators(W var1, RowData var2) throws Exception;

        public void clearWindowState(W var1) throws Exception;

        public void clearPreviousState(W var1) throws Exception;

        public void clearTrigger(W var1) throws Exception;

        public void onMerge(W var1, Collection<W> var2) throws Exception;

        public void deleteCleanupTimer(W var1) throws Exception;
    }
}

