/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
class MapInputTypeStrategy
implements InputTypeStrategy {
    private static final ArgumentCount AT_LEAST_TWO_EVEN = new ArgumentCount(){

        @Override
        public boolean isValidCount(int count) {
            return count % 2 == 0;
        }

        @Override
        public Optional<Integer> getMinCount() {
            return Optional.of(2);
        }

        @Override
        public Optional<Integer> getMaxCount() {
            return Optional.empty();
        }
    };

    MapInputTypeStrategy() {
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return AT_LEAST_TWO_EVEN;
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        if (argumentDataTypes.size() == 0) {
            return Optional.empty();
        }
        ArrayList<LogicalType> keyTypes = new ArrayList<LogicalType>();
        ArrayList<LogicalType> valueTypes = new ArrayList<LogicalType>();
        for (int i = 0; i < argumentDataTypes.size(); ++i) {
            LogicalType logicalType = argumentDataTypes.get(i).getLogicalType();
            if (i % 2 == 0) {
                keyTypes.add(logicalType);
                continue;
            }
            valueTypes.add(logicalType);
        }
        Optional<LogicalType> commonKeyType = LogicalTypeMerging.findCommonType(keyTypes);
        Optional<LogicalType> commonValueType = LogicalTypeMerging.findCommonType(valueTypes);
        if (!commonKeyType.isPresent() || !commonValueType.isPresent()) {
            return Optional.empty();
        }
        DataType keyType = TypeConversions.fromLogicalToDataType(commonKeyType.get());
        DataType valueType = TypeConversions.fromLogicalToDataType(commonValueType.get());
        return Optional.of(IntStream.range(0, argumentDataTypes.size()).mapToObj(idx -> {
            if (idx % 2 == 0) {
                return keyType;
            }
            return valueType;
        }).collect(Collectors.toList()));
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return Collections.singletonList(Signature.of(Signature.Argument.of("*")));
    }
}

