/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.tvf.operator;

import java.time.ZoneId;
import java.util.Collection;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Counter;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.GroupWindowAssigner;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.util.Preconditions;

public abstract class WindowTableFunctionOperatorBase
extends TableStreamOperator<RowData>
implements OneInputStreamOperator<RowData, RowData> {
    private static final String NULL_ROW_TIME_ELEMENTS_DROPPED_METRIC_NAME = "numNullRowTimeRecordsDropped";
    protected final ZoneId shiftTimeZone;
    protected final int rowtimeIndex;
    protected final GroupWindowAssigner<TimeWindow> windowAssigner;
    private transient TimestampedCollector<RowData> collector;
    private transient JoinedRowData outRow;
    private transient GenericRowData windowProperties;
    protected transient Counter numNullRowTimeRecordsDropped;

    public WindowTableFunctionOperatorBase(GroupWindowAssigner<TimeWindow> windowAssigner, int rowtimeIndex, ZoneId shiftTimeZone) {
        this.shiftTimeZone = shiftTimeZone;
        this.rowtimeIndex = rowtimeIndex;
        this.windowAssigner = windowAssigner;
        Preconditions.checkArgument((!windowAssigner.isEventTime() || rowtimeIndex >= 0 ? 1 : 0) != 0);
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.collector = new TimestampedCollector(this.output);
        this.collector.eraseTimestamp();
        this.outRow = new JoinedRowData();
        this.windowProperties = new GenericRowData(3);
        this.numNullRowTimeRecordsDropped = this.metrics.counter(NULL_ROW_TIME_ELEMENTS_DROPPED_METRIC_NAME);
    }

    public void close() throws Exception {
        super.close();
        if (this.collector != null) {
            this.collector.close();
        }
    }

    protected void collect(RowData inputRow, Collection<TimeWindow> allWindows) {
        for (TimeWindow window : allWindows) {
            this.windowProperties.setField(0, (Object)TimestampData.fromEpochMillis((long)window.getStart()));
            this.windowProperties.setField(1, (Object)TimestampData.fromEpochMillis((long)window.getEnd()));
            this.windowProperties.setField(2, (Object)TimestampData.fromEpochMillis((long)TimeWindowUtil.toEpochMills(window.maxTimestamp(), this.shiftTimeZone)));
            this.outRow.replace(inputRow, (RowData)this.windowProperties);
            this.outRow.setRowKind(inputRow.getRowKind());
            this.collector.collect((Object)this.outRow);
        }
    }

    @VisibleForTesting
    public Counter getNumNullRowTimeRecordsDropped() {
        return this.numNullRowTimeRecordsDropped;
    }
}

