/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class AppendOnlyFirstNFunction
extends AbstractTopNFunction {
    private static final long serialVersionUID = -889227691088906247L;
    private ValueState<Integer> state;

    public AppendOnlyFirstNFunction(StateTtlConfig ttlConfig, InternalTypeInfo<RowData> inputRowType, GeneratedRecordComparator sortKeyGeneratedRecordComparator, RowDataKeySelector sortKeySelector, RankType rankType, RankRange rankRange, boolean generateUpdateBefore, boolean outputRankNumber) {
        super(ttlConfig, inputRowType, sortKeyGeneratedRecordComparator, sortKeySelector, rankType, rankRange, generateUpdateBefore, outputRankNumber);
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        ValueStateDescriptor stateDesc = new ValueStateDescriptor("counterState", Types.INT);
        if (this.ttlConfig.isEnabled()) {
            stateDesc.enableTimeToLive(this.ttlConfig);
        }
        this.state = this.getRuntimeContext().getState(stateDesc);
    }

    public void processElement(RowData input, KeyedProcessFunction.Context context, Collector<RowData> out) throws Exception {
        int currentRank;
        this.initRankEnd(input);
        Preconditions.checkArgument((input.getRowKind() == RowKind.INSERT ? 1 : 0) != 0);
        int n = currentRank = this.state.value() == null ? 0 : (Integer)this.state.value();
        if ((long)currentRank >= this.rankEnd) {
            return;
        }
        this.state.update((Object)(++currentRank));
        if (this.outputRankNumber || this.hasOffset()) {
            this.collectInsert(out, input, currentRank);
        } else {
            this.collectInsert(out, input);
        }
    }
}

