/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.QueueBalancer;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class RandomQueueBalancer
implements QueueBalancer {
    private final int queueSize;
    private final List<BlockingQueue<CallRunner>> queues;

    public RandomQueueBalancer(Configuration conf, String executorName, List<BlockingQueue<CallRunner>> queues) {
        this.queueSize = queues.size();
        this.queues = queues;
    }

    @Override
    public int getNextQueue(CallRunner callRunner) {
        return ThreadLocalRandom.current().nextInt(this.queueSize);
    }

    List<BlockingQueue<CallRunner>> getQueues() {
        return this.queues;
    }
}

