/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.balancer.RegionReplicaGroupingCostFunction;
import org.apache.hadoop.hbase.shaded.org.agrona.collections.Int2IntCounterMap;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RegionReplicaHostCostFunction
extends RegionReplicaGroupingCostFunction {
    private static final String REGION_REPLICA_HOST_COST_KEY = "hbase.master.balancer.stochastic.regionReplicaHostCostKey";
    private static final float DEFAULT_REGION_REPLICA_HOST_COST_KEY = 100000.0f;
    private Int2IntCounterMap[] colocatedReplicaCountsPerGroup;

    public RegionReplicaHostCostFunction(Configuration conf) {
        this.setMultiplier(conf.getFloat(REGION_REPLICA_HOST_COST_KEY, 100000.0f));
    }

    @Override
    protected void loadCosts() {
        this.maxCost = this.cluster.numHosts > 1 ? this.getMaxCost(this.cluster) : 0L;
        this.costsPerGroup = new long[this.cluster.numHosts];
        this.colocatedReplicaCountsPerGroup = this.cluster.multiServersPerHost ? this.cluster.colocatedReplicaCountsPerHost : this.cluster.colocatedReplicaCountsPerServer;
        for (int i = 0; i < this.colocatedReplicaCountsPerGroup.length; ++i) {
            this.costsPerGroup[i] = this.costPerGroup(this.colocatedReplicaCountsPerGroup[i]);
        }
    }

    @Override
    protected void regionMoved(int region, int oldServer, int newServer) {
        if (this.maxCost <= 0L) {
            return;
        }
        if (this.cluster.multiServersPerHost) {
            int newHost = this.cluster.serverIndexToHostIndex[newServer];
            int oldHost = this.cluster.serverIndexToHostIndex[oldServer];
            if (newHost != oldHost) {
                this.costsPerGroup[oldHost] = this.costPerGroup(this.cluster.colocatedReplicaCountsPerHost[oldHost]);
                this.costsPerGroup[newHost] = this.costPerGroup(this.cluster.colocatedReplicaCountsPerHost[newHost]);
            }
        } else {
            this.costsPerGroup[oldServer] = this.costPerGroup(this.cluster.colocatedReplicaCountsPerServer[oldServer]);
            this.costsPerGroup[newServer] = this.costPerGroup(this.cluster.colocatedReplicaCountsPerServer[newServer]);
        }
    }
}

