/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.server.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.client.trace.IpcClientSpanBuilder;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.trace.HBaseSemanticAttributes;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class IpcServerSpanBuilder
implements Supplier<Span> {
    private String name;
    private final Map<AttributeKey<?>, Object> attributes = new HashMap();

    public IpcServerSpanBuilder(RpcCall rpcCall) {
        String packageAndService = Optional.ofNullable(rpcCall.getService()).map(BlockingService::getDescriptorForType).map(IpcClientSpanBuilder::getRpcPackageAndService).orElse("");
        String method = Optional.ofNullable(rpcCall.getMethod()).map(IpcClientSpanBuilder::getRpcName).orElse("");
        this.setName(IpcClientSpanBuilder.buildSpanName(packageAndService, method));
        this.addAttribute(HBaseSemanticAttributes.RPC_SYSTEM, HBaseSemanticAttributes.RpcSystem.HBASE_RPC.name());
        this.addAttribute(HBaseSemanticAttributes.RPC_SERVICE, packageAndService);
        this.addAttribute(HBaseSemanticAttributes.RPC_METHOD, method);
    }

    @Override
    public Span get() {
        return this.build();
    }

    public IpcServerSpanBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public <T> IpcServerSpanBuilder addAttribute(AttributeKey<T> key, T value) {
        this.attributes.put(key, value);
        return this;
    }

    public Span build() {
        SpanBuilder builder = TraceUtil.getGlobalTracer().spanBuilder(this.name).setSpanKind(SpanKind.SERVER);
        this.attributes.forEach((k, v) -> builder.setAttribute(k, v));
        return builder.startSpan();
    }
}

