/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import org.apache.hadoop.hbase.quotas.RateLimiter;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FixedIntervalRateLimiter
extends RateLimiter {
    private long nextRefillTime = -1L;

    @Override
    public long refill(long limit) {
        long now = EnvironmentEdgeManager.currentTime();
        if (now < this.nextRefillTime) {
            return 0L;
        }
        this.nextRefillTime = now + super.getTimeUnitInMillis();
        return limit;
    }

    @Override
    public long getWaitInterval(long limit, long available, long amount) {
        if (this.nextRefillTime == -1L) {
            return 0L;
        }
        long now = EnvironmentEdgeManager.currentTime();
        long refillTime = this.nextRefillTime;
        long diff = amount - available;
        long nextRefillInterval = refillTime - now;
        if (diff <= limit) {
            return nextRefillInterval;
        }
        long extraRefillsNecessary = diff / limit;
        if (diff % limit == 0L) {
            --extraRefillsNecessary;
        }
        return nextRefillInterval + extraRefillsNecessary * super.getTimeUnitInMillis();
    }

    @Override
    public void setNextRefillTime(long nextRefillTime) {
        this.nextRefillTime = nextRefillTime;
    }

    @Override
    public long getNextRefillTime() {
        return this.nextRefillTime;
    }
}

