/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.SnapshotScannerHDFSAclCleaner;
import org.apache.hadoop.hbase.security.access.SnapshotScannerHDFSAclController;
import org.apache.hadoop.hbase.security.access.SnapshotScannerHDFSAclHelper;
import org.apache.hadoop.hbase.security.access.TestHDFSAclHelper;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SecurityTests.class, LargeTests.class})
public class TestSnapshotScannerHDFSAclController {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotScannerHDFSAclController.class);
    @Rule
    public TestName name = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotScannerHDFSAclController.class);
    private static final String UN_GRANT_USER = "un_grant_user";
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf = TEST_UTIL.getConfiguration();
    private static Admin admin = null;
    private static FileSystem FS = null;
    private static Path rootDir = null;
    private static User unGrantUser = null;
    private static SnapshotScannerHDFSAclHelper helper;
    private static Table aclTable;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Path path;
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.set("fs.permissions.umask-mode", "027");
        conf.setBoolean("hbase.acl.sync.to.hdfs.enable", true);
        conf.set("hbase.security.authentication", "simple");
        conf.set("hbase.snapshot.restore.tmp.dir", "/hbase/.tmpdir-to-restore-snapshot");
        SecureTestUtil.enableSecurity(conf);
        conf.set("hbase.coprocessor.master.classes", conf.get("hbase.coprocessor.master.classes") + "," + SnapshotScannerHDFSAclController.class.getName());
        TEST_UTIL.startMiniCluster();
        SnapshotScannerHDFSAclController coprocessor = (SnapshotScannerHDFSAclController)TEST_UTIL.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(SnapshotScannerHDFSAclController.class);
        TEST_UTIL.waitFor(30000L, () -> coprocessor.checkInitialized("check initialized"));
        TEST_UTIL.waitTableAvailable(PermissionStorage.ACL_TABLE_NAME);
        admin = TEST_UTIL.getAdmin();
        rootDir = TEST_UTIL.getDefaultRootDirPath();
        FS = rootDir.getFileSystem(conf);
        unGrantUser = User.createUserForTesting((Configuration)conf, (String)UN_GRANT_USER, (String[])new String[0]);
        helper = new SnapshotScannerHDFSAclHelper(conf, admin.getConnection());
        FsPermission commonDirectoryPermission = new FsPermission(conf.get("hbase.acl.sync.to.hdfs.common.directory.permission", "751"));
        for (path = rootDir; path != null; path = path.getParent()) {
            FS.setPermission(path, commonDirectoryPermission);
        }
        Path restoreDir = new Path("/hbase/.tmpdir-to-restore-snapshot");
        if (!FS.exists(restoreDir)) {
            FS.mkdirs(restoreDir);
            FS.setPermission(restoreDir, new FsPermission(conf.get("hbase.acl.sync.to.hdfs.restore.directory.permission", "753")));
        }
        for (path = restoreDir.getParent(); path != null; path = path.getParent()) {
            FS.setPermission(path, commonDirectoryPermission);
        }
        aclTable = admin.getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private void snapshotAndWait(String snapShotName, TableName tableName) throws Exception {
        admin.snapshot(snapShotName, tableName);
        LOG.info("Sleep for one second, waiting for HDFS Acl setup");
        Threads.sleep((long)3000L);
    }

    @Test
    public void testGrantGlobal1() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot1 = namespace + "s1";
        String snapshot2 = namespace + "s2";
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table);
        this.snapshotAndWait(snapshot1, table);
        SecureTestUtil.grantGlobal(TEST_UTIL, grantUserName, Permission.Action.READ);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, 6);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl((Table)aclTable, (String)grantUserName));
        admin.grant(new UserPermission(grantUserName, Permission.newBuilder().withActions(new Permission.Action[]{Permission.Action.WRITE}).build()), true);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, 6);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl((Table)aclTable, (String)grantUserName));
        SecureTestUtil.grantGlobal(TEST_UTIL, grantUserName, Permission.Action.WRITE);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, -1);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl((Table)aclTable, (String)grantUserName));
        SecureTestUtil.grantGlobal(TEST_UTIL, grantUserName, Permission.Action.READ);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, 6);
        this.snapshotAndWait(snapshot2, table);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot2, 6);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl((Table)aclTable, (String)grantUserName));
        TestSnapshotScannerHDFSAclController.deleteTable(table);
    }

    @Test
    public void testGrantGlobal2() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace1 = this.name.getMethodName();
        TableName table1 = TableName.valueOf((String)namespace1, (String)(this.name.getMethodName() + ".1"));
        String namespace2 = namespace1 + "2";
        TableName table2 = TableName.valueOf((String)namespace2, (String)(this.name.getMethodName() + ".2"));
        String snapshot1 = namespace1 + "s1";
        String snapshot2 = namespace2 + "s2";
        SecureTestUtil.grantGlobal(TEST_UTIL, grantUserName, Permission.Action.READ);
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table1);
        this.snapshotAndWait(snapshot1, table1);
        admin.grant(new UserPermission(grantUserName, Permission.newBuilder((String)namespace1).withActions(new Permission.Action[]{Permission.Action.READ}).build()), false);
        SecureTestUtil.grantGlobal(TEST_UTIL, grantUserName, Permission.Action.WRITE);
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table2);
        this.snapshotAndWait(snapshot2, table2);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, 6);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot2, -1);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl((Table)aclTable, (String)grantUserName));
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName, (String)namespace1));
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName, (String)namespace2));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getGlobalRootPaths(), grantUserName, false, false);
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace1), grantUserName, true, true);
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace2), grantUserName, false, false);
        TestSnapshotScannerHDFSAclController.deleteTable(table1);
        TestSnapshotScannerHDFSAclController.deleteTable(table2);
    }

    @Test
    public void testGrantGlobal3() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table1 = TableName.valueOf((String)namespace, (String)(this.name.getMethodName() + ".1"));
        TableName table2 = TableName.valueOf((String)namespace, (String)(this.name.getMethodName() + ".2"));
        String snapshot1 = namespace + "s1";
        String snapshot2 = namespace + "s2";
        SecureTestUtil.grantGlobal(TEST_UTIL, grantUserName, Permission.Action.READ);
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table1);
        this.snapshotAndWait(snapshot1, table1);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName, table1, Permission.Action.READ);
        SecureTestUtil.grantGlobal(TEST_UTIL, grantUserName, Permission.Action.WRITE);
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table2);
        this.snapshotAndWait(snapshot2, table2);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, 6);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot2, -1);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl((Table)aclTable, (String)grantUserName));
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName, (String)namespace));
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)table1));
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)table2));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getGlobalRootPaths(), grantUserName, false, false);
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table2, false), grantUserName, false, false);
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table1, false), grantUserName, true, true);
        TestSnapshotScannerHDFSAclController.deleteTable(table1);
        TestSnapshotScannerHDFSAclController.deleteTable(table2);
    }

    @Test
    public void testGrantNamespace1() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table1 = TableName.valueOf((String)namespace, (String)(this.name.getMethodName() + ".1"));
        TableName table2 = TableName.valueOf((String)namespace, (String)(this.name.getMethodName() + ".2"));
        String snapshot1 = namespace + "s1";
        String snapshot2 = namespace + "s2";
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table1);
        this.snapshotAndWait(snapshot1, table1);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUserName, namespace, Permission.Action.READ);
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table2);
        this.snapshotAndWait(snapshot2, table2);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, 6);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot2, 6);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, unGrantUser, snapshot1, -1);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName, (String)namespace));
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)table1));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace), grantUserName, true, true);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUserName, namespace, Permission.Action.WRITE);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, -1);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName, (String)namespace));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace), grantUserName, false, false);
        TestSnapshotScannerHDFSAclController.deleteTable(table1);
        TestSnapshotScannerHDFSAclController.deleteTable(table2);
    }

    @Test
    public void testGrantNamespace2() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table1 = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot1 = namespace + "s1";
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table1);
        this.snapshotAndWait(snapshot1, table1);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUserName, namespace, Permission.Action.READ);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName, table1, Permission.Action.READ);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUserName, namespace, Permission.Action.WRITE);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, 6);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName, (String)namespace));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace), grantUserName, true, false);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)table1));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table1, false), grantUserName, true, true);
        TestSnapshotScannerHDFSAclController.deleteTable(table1);
    }

    @Test
    public void testGrantNamespace3() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot = namespace + "t1";
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table);
        this.snapshotAndWait(snapshot, table);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUserName, namespace, Permission.Action.READ);
        SecureTestUtil.grantGlobal(TEST_UTIL, grantUserName, Permission.Action.READ);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUserName, namespace, Permission.Action.WRITE);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot, 6);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName, (String)namespace));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace), grantUserName, true, true);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl((Table)aclTable, (String)grantUserName));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getGlobalRootPaths(), grantUserName, true, true);
        TestSnapshotScannerHDFSAclController.deleteTable(table);
    }

    @Test
    public void testGrantTable() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table1 = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot1 = namespace + "s1";
        String snapshot2 = namespace + "s2";
        LOG.info("Create table");
        try (Table t = TestHDFSAclHelper.createTable(TEST_UTIL, table1);){
            TestHDFSAclHelper.put(t);
            this.snapshotAndWait(snapshot1, table1);
            LOG.info("Scan snapshot");
            TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]), snapshot1, 6);
            SecureTestUtil.grantOnTable(TEST_UTIL, grantUserName, table1, TestHDFSAclHelper.COLUMN1, null, Permission.Action.READ);
            TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, -1);
            TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName, table1, Permission.Action.READ);
            TestHDFSAclHelper.put2(t);
            this.snapshotAndWait(snapshot2, table1);
            TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, 6);
            TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot2, 10);
            Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)table1));
            TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table1, false), grantUserName, true, true);
        }
        admin.grant(new UserPermission(grantUserName, Permission.newBuilder((TableName)table1).withActions(new Permission.Action[]{Permission.Action.WRITE}).build()), true);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)table1));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table1, false), grantUserName, true, true);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName, table1, Permission.Action.WRITE);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, -1);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)table1));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table1, false), grantUserName, false, false);
        TestSnapshotScannerHDFSAclController.deleteTable(table1);
    }

    @Test
    public void testGrantMobTable() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot = namespace + "s1";
        try (Table t = TestHDFSAclHelper.createMobTable(TEST_UTIL, table);){
            TestHDFSAclHelper.put(t);
            this.snapshotAndWait(snapshot, table);
            TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName, table, Permission.Action.READ);
            TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot, 6);
            Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)table));
            TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table, false), grantUserName, true, true);
        }
        TestSnapshotScannerHDFSAclController.deleteTable(table);
    }

    @Test
    public void testRevokeGlobal1() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table1 = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot1 = namespace + "t1";
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table1);
        this.snapshotAndWait(snapshot1, table1);
        SecureTestUtil.grantGlobal(TEST_UTIL, grantUserName, Permission.Action.READ);
        SecureTestUtil.revokeGlobal(TEST_UTIL, grantUserName, Permission.Action.READ);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, -1);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl((Table)aclTable, (String)grantUserName));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getGlobalRootPaths(), grantUserName, false, false);
        TestSnapshotScannerHDFSAclController.deleteTable(table1);
    }

    @Test
    public void testRevokeGlobal2() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        String snapshot1 = namespace + "s1";
        TableName table1 = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table1);
        this.snapshotAndWait(snapshot1, table1);
        SecureTestUtil.grantGlobal(TEST_UTIL, grantUserName, Permission.Action.READ);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUserName, namespace, Permission.Action.READ);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName, table1, Permission.Action.READ);
        SecureTestUtil.revokeGlobal(TEST_UTIL, grantUserName, Permission.Action.READ);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, 6);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl((Table)aclTable, (String)grantUserName));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getGlobalRootPaths(), grantUserName, false, false);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName, (String)namespace));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace), grantUserName, true, true);
        TestSnapshotScannerHDFSAclController.deleteTable(table1);
    }

    @Test
    public void testRevokeGlobal3() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table1 = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot1 = namespace + "t1";
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table1);
        this.snapshotAndWait(snapshot1, table1);
        SecureTestUtil.grantGlobal(TEST_UTIL, grantUserName, Permission.Action.READ);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName, table1, Permission.Action.READ);
        SecureTestUtil.revokeGlobal(TEST_UTIL, grantUserName, Permission.Action.READ);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, 6);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl((Table)aclTable, (String)grantUserName));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getGlobalRootPaths(), grantUserName, false, false);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName, (String)namespace));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace), grantUserName, true, false);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)table1));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table1, false), grantUserName, true, true);
        TestSnapshotScannerHDFSAclController.deleteTable(table1);
    }

    @Test
    public void testRevokeNamespace1() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table1 = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot1 = namespace + "s1";
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table1);
        this.snapshotAndWait(snapshot1, table1);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUserName, namespace, Permission.Action.READ);
        admin.revoke(new UserPermission(grantUserName, Permission.newBuilder((String)namespace).build()));
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, -1);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName, (String)namespace));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace), grantUserName, false, false);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUserName, namespace, Permission.Action.READ);
        SecureTestUtil.grantGlobal(TEST_UTIL, grantUserName, Permission.Action.READ);
        admin.revoke(new UserPermission(grantUserName, Permission.newBuilder((String)namespace).build()));
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot1, 6);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName, (String)namespace));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace), grantUserName, true, true);
        TestSnapshotScannerHDFSAclController.deleteTable(table1);
    }

    @Test
    public void testRevokeNamespace2() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot = namespace + "s1";
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table);
        this.snapshotAndWait(snapshot, table);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUserName, namespace, Permission.Action.READ);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName, table, Permission.Action.READ);
        SecureTestUtil.revokeFromNamespace(TEST_UTIL, grantUserName, namespace, Permission.Action.READ);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot, 6);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName, (String)namespace));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace), grantUserName, true, false);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)table));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table, false), grantUserName, true, true);
        TestSnapshotScannerHDFSAclController.deleteTable(table);
    }

    @Test
    public void testRevokeTable1() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot = namespace + "t1";
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table);
        this.snapshotAndWait(snapshot, table);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName, table, Permission.Action.READ);
        SecureTestUtil.revokeFromTable(TEST_UTIL, grantUserName, table, TestHDFSAclHelper.COLUMN1, null, Permission.Action.READ);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot, 6);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName, table, Permission.Action.READ);
        admin.revoke(new UserPermission(grantUserName, Permission.newBuilder((TableName)table).build()));
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot, -1);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)table));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table, false), grantUserName, false, false);
        TestSnapshotScannerHDFSAclController.deleteTable(table);
    }

    @Test
    public void testRevokeTable2() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot = namespace + "t1";
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table);
        this.snapshotAndWait(snapshot, table);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName, table, Permission.Action.READ);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUserName, namespace, Permission.Action.READ);
        admin.revoke(new UserPermission(grantUserName, Permission.newBuilder((TableName)table).build()));
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot, 6);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)table));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table, false), grantUserName, true, true);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName, (String)namespace));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace), grantUserName, true, true);
        TestSnapshotScannerHDFSAclController.deleteTable(table);
    }

    @Test
    public void testRevokeTable3() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot = namespace + "t1";
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table);
        this.snapshotAndWait(snapshot, table);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName, table, Permission.Action.READ);
        SecureTestUtil.grantGlobal(TEST_UTIL, grantUserName, Permission.Action.READ);
        admin.revoke(new UserPermission(grantUserName, Permission.newBuilder((TableName)table).build()));
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot, 6);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)table));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table, false), grantUserName, true, true);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl((Table)aclTable, (String)grantUserName));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getGlobalRootPaths(), grantUserName, true, true);
        TestSnapshotScannerHDFSAclController.deleteTable(table);
    }

    @Test
    public void testTruncateTable() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String grantUserName2 = grantUserName + "2";
        User grantUser2 = User.createUserForTesting((Configuration)conf, (String)grantUserName2, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName tableName = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot = namespace + "s1";
        String snapshot2 = namespace + "s2";
        try (Table t = TestHDFSAclHelper.createTable(TEST_UTIL, tableName);){
            TestHDFSAclHelper.put(t);
            this.snapshotAndWait(snapshot, tableName);
            SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUserName2, namespace, Permission.Action.READ);
            TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName, tableName, Permission.Action.READ);
            admin.disableTable(tableName);
            admin.truncateTable(tableName, true);
            TestHDFSAclHelper.put2(t);
            this.snapshotAndWait(snapshot2, tableName);
            TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot, 6);
            TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser2, snapshot, 6);
            TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot2, 9);
            TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser2, snapshot2, 9);
            Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName2, (String)namespace));
            TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace), grantUserName2, true, true);
            Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName, (TableName)tableName));
            TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(tableName, false), grantUserName, true, true);
            TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace), grantUserName, true, false);
        }
        TestSnapshotScannerHDFSAclController.deleteTable(tableName);
    }

    @Test
    public void testDeleteTable() throws Exception {
        String namespace = this.name.getMethodName();
        String grantUserName1 = namespace + "1";
        String grantUserName2 = namespace + "2";
        User grantUser1 = User.createUserForTesting((Configuration)conf, (String)grantUserName1, (String[])new String[0]);
        User grantUser2 = User.createUserForTesting((Configuration)conf, (String)grantUserName2, (String[])new String[0]);
        TableName table = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot1 = namespace + "t1";
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table);
        this.snapshotAndWait(snapshot1, table);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName1, table, Permission.Action.READ);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUserName2, namespace, Permission.Action.READ);
        admin.disableTable(table);
        admin.deleteTable(table);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser1, snapshot1, -1);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser2, snapshot1, 6);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName2, (String)namespace));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace), grantUserName2, true, true);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUserName1, (TableName)table));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getPathHelper().getDataTableDir(table), grantUserName1, false, false);
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getPathHelper().getMobTableDir(table), grantUserName1, false, false);
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getPathHelper().getArchiveTableDir(table), grantUserName1, true, false);
        Path tmpTableDir = helper.getPathHelper().getTmpTableDir(table);
        Assert.assertFalse((boolean)FS.exists(tmpTableDir));
        TestSnapshotScannerHDFSAclController.deleteTable(table);
    }

    @Test
    public void testDeleteTable2() throws Exception {
        String namespace1 = this.name.getMethodName() + "1";
        String namespace2 = this.name.getMethodName() + "2";
        String grantUser = this.name.getMethodName();
        TableName table = TableName.valueOf((String)namespace1, (String)this.name.getMethodName());
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUser, table, Permission.Action.READ);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUser, namespace2, Permission.Action.READ);
        admin.disableTable(table);
        admin.deleteTable(table);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)grantUser, (TableName)table));
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUser, (String)namespace2));
    }

    @Test
    public void testDeleteNamespace() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot = namespace + "t1";
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table);
        this.snapshotAndWait(snapshot, table);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUserName, namespace, Permission.Action.READ);
        admin.disableTable(table);
        admin.deleteTable(table);
        admin.deleteNamespace(namespace);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot, 6);
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)grantUserName, (String)namespace));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getPathHelper().getArchiveNsDir(namespace), grantUserName, true, false);
        Assert.assertFalse((boolean)FS.exists(helper.getPathHelper().getTmpNsDir(namespace)));
        Assert.assertFalse((boolean)FS.exists(helper.getPathHelper().getDataNsDir(namespace)));
        TestSnapshotScannerHDFSAclController.deleteTable(table);
    }

    @Test
    public void testCleanArchiveTableDir() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot = namespace + "t1";
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table);
        this.snapshotAndWait(snapshot, table);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, grantUserName, table, Permission.Action.READ);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot, 6);
        HFileCleaner cleaner = TEST_UTIL.getHBaseCluster().getMaster().getHFileCleaner();
        cleaner.choreForTesting();
        Path archiveTableDir = HFileArchiveUtil.getTableArchivePath((Path)rootDir, (TableName)table);
        Assert.assertTrue((boolean)FS.exists(archiveTableDir));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table, false), grantUserName, true, true);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclCleaner.isArchiveTableDir((Path)archiveTableDir));
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclCleaner.isArchiveNamespaceDir((Path)archiveTableDir.getParent()));
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclCleaner.isArchiveDataDir((Path)archiveTableDir.getParent().getParent()));
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclCleaner.isArchiveDataDir((Path)archiveTableDir.getParent().getParent().getParent()));
        TestSnapshotScannerHDFSAclController.deleteTable(table);
    }

    @Test
    public void testModifyTable1() throws Exception {
        String namespace = this.name.getMethodName();
        TableName table = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        String snapshot = namespace + "t1";
        String tableUserName = this.name.getMethodName();
        User tableUser = User.createUserForTesting((Configuration)conf, (String)tableUserName, (String[])new String[0]);
        String tableUserName2 = tableUserName + "2";
        User tableUser2 = User.createUserForTesting((Configuration)conf, (String)tableUserName2, (String[])new String[0]);
        String tableUserName3 = tableUserName + "3";
        User tableUser3 = User.createUserForTesting((Configuration)conf, (String)tableUserName3, (String[])new String[0]);
        String nsUserName = tableUserName + "-ns";
        User nsUser = User.createUserForTesting((Configuration)conf, (String)nsUserName, (String[])new String[0]);
        String globalUserName = tableUserName + "-global";
        User globalUser = User.createUserForTesting((Configuration)conf, (String)globalUserName, (String[])new String[0]);
        String globalUserName2 = tableUserName + "-global-2";
        User globalUser2 = User.createUserForTesting((Configuration)conf, (String)globalUserName2, (String[])new String[0]);
        SecureTestUtil.grantGlobal(TEST_UTIL, globalUserName, Permission.Action.READ);
        TestHDFSAclHelper.createNamespace(TEST_UTIL, namespace);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, nsUserName, namespace, Permission.Action.READ);
        TableDescriptor td = TestHDFSAclHelper.createUserScanSnapshotDisabledTable(TEST_UTIL, table);
        this.snapshotAndWait(snapshot, table);
        SecureTestUtil.grantGlobal(TEST_UTIL, globalUserName2, Permission.Action.READ);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, tableUserName, table, Permission.Action.READ);
        SecureTestUtil.grantOnTable(TEST_UTIL, tableUserName2, table, TestHDFSAclHelper.COLUMN1, null, Permission.Action.READ);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, tableUserName3, table, Permission.Action.WRITE);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, tableUser, snapshot, -1);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, tableUser2, snapshot, -1);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, tableUser3, snapshot, -1);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, nsUser, snapshot, -1);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, globalUser, snapshot, 6);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, globalUser2, snapshot, -1);
        admin.modifyTable(TableDescriptorBuilder.newBuilder((TableDescriptor)td).setValue("hbase.acl.sync.to.hdfs.enable", "true").build());
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, tableUser, snapshot, 6);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, tableUser2, snapshot, -1);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, tableUser3, snapshot, -1);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, nsUser, snapshot, 6);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, globalUser, snapshot, 6);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserGlobalHdfsAcl((Table)aclTable, (String)globalUserName));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getGlobalRootPaths(), globalUserName, true, true);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)nsUserName, (String)namespace));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getNamespaceRootPaths(namespace), nsUserName, true, true);
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)tableUserName, (TableName)table));
        TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table, false), tableUserName, true, true);
        for (String user : new String[]{tableUserName2, tableUserName3}) {
            Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)user, (TableName)table));
            TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, helper.getTableRootPaths(table, false), user, false, false);
        }
        TestSnapshotScannerHDFSAclController.deleteTable(table);
    }

    @Test
    public void testModifyTable2() throws Exception {
        String namespace = this.name.getMethodName();
        TableName table = TableName.valueOf((String)namespace, (String)(this.name.getMethodName() + ".1"));
        String snapshot = namespace + "t1";
        TableName table2 = TableName.valueOf((String)namespace, (String)(this.name.getMethodName() + ".2"));
        String tableUserName = this.name.getMethodName();
        User tableUser = User.createUserForTesting((Configuration)conf, (String)tableUserName, (String[])new String[0]);
        String tableUserName2 = tableUserName + "2";
        User tableUser2 = User.createUserForTesting((Configuration)conf, (String)tableUserName2, (String[])new String[0]);
        String tableUserName3 = tableUserName + "3";
        User tableUser3 = User.createUserForTesting((Configuration)conf, (String)tableUserName3, (String[])new String[0]);
        String nsUserName = tableUserName + "-ns";
        User nsUser = User.createUserForTesting((Configuration)conf, (String)nsUserName, (String[])new String[0]);
        String globalUserName = tableUserName + "-global";
        User globalUser = User.createUserForTesting((Configuration)conf, (String)globalUserName, (String[])new String[0]);
        String globalUserName2 = tableUserName + "-global-2";
        User globalUser2 = User.createUserForTesting((Configuration)conf, (String)globalUserName2, (String[])new String[0]);
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table);
        SecureTestUtil.grantGlobal(TEST_UTIL, globalUserName, Permission.Action.READ);
        SecureTestUtil.grantGlobal(TEST_UTIL, globalUserName2, Permission.Action.READ);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, nsUserName, namespace, Permission.Action.READ);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, tableUserName, table, Permission.Action.READ);
        SecureTestUtil.grantOnTable(TEST_UTIL, tableUserName2, table, TestHDFSAclHelper.COLUMN1, null, Permission.Action.READ);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, tableUserName3, table, Permission.Action.WRITE);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, tableUserName2, namespace, Permission.Action.READ);
        TestHDFSAclHelper.createTable(TEST_UTIL, table2);
        TestHDFSAclHelper.grantOnTable(TEST_UTIL, tableUserName3, table2, Permission.Action.READ);
        admin.modifyTable(TableDescriptorBuilder.newBuilder((TableDescriptor)admin.getDescriptor(table)).setValue("hbase.acl.sync.to.hdfs.enable", "false").build());
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, tableUser, snapshot, -1);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, tableUser2, snapshot, -1);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, tableUser3, snapshot, -1);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, nsUser, snapshot, -1);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, globalUser, snapshot, -1);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, globalUser2, snapshot, -1);
        String[] users = new String[]{globalUserName, globalUserName2, nsUserName, tableUserName, tableUserName2, tableUserName3};
        for (Path path : helper.getTableRootPaths(table, false)) {
            for (String user : users) {
                TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, path, user, false, false);
            }
        }
        String[] nsUsers = new String[]{globalUserName, globalUserName2, nsUserName};
        for (Path path : helper.getNamespaceRootPaths(namespace)) {
            TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, path, tableUserName, false, false);
            TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, path, tableUserName2, true, true);
            TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, path, tableUserName3, true, false);
            for (String user : nsUsers) {
                TestSnapshotScannerHDFSAclController.checkUserAclEntry(FS, path, user, true, true);
            }
        }
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)nsUserName, (String)namespace));
        Assert.assertTrue((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserNamespaceHdfsAcl((Table)aclTable, (String)tableUserName2, (String)namespace));
        Assert.assertFalse((boolean)SnapshotScannerHDFSAclController.SnapshotScannerHDFSAclStorage.hasUserTableHdfsAcl((Table)aclTable, (String)tableUserName, (TableName)table));
        TestSnapshotScannerHDFSAclController.deleteTable(table);
        TestSnapshotScannerHDFSAclController.deleteTable(table2);
    }

    @Test
    public void testRestartMaster() throws Exception {
        String grantUserName = this.name.getMethodName();
        User grantUser = User.createUserForTesting((Configuration)conf, (String)grantUserName, (String[])new String[0]);
        String namespace = this.name.getMethodName();
        TableName table = TableName.valueOf((String)namespace, (String)(this.name.getMethodName() + ".1"));
        TableName table2 = TableName.valueOf((String)namespace, (String)(this.name.getMethodName() + ".2"));
        String snapshot = namespace + "t1";
        admin.createNamespace(NamespaceDescriptor.create((String)namespace).build());
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table2);
        Path tmpTableDir = helper.getPathHelper().getTmpTableDir(table2);
        FS.mkdirs(new Path(tmpTableDir, "1"));
        for (Path regionDir : FSUtils.getRegionDirs((FileSystem)FS, (Path)helper.getPathHelper().getDataTableDir(table2))) {
            FSUtils.copyFilesParallel((FileSystem)FS, (Path)regionDir, (FileSystem)FS, (Path)new Path(tmpTableDir, regionDir.getName() + "abc"), (Configuration)conf, (int)1);
        }
        Assert.assertEquals((long)4L, (long)FS.listStatus(tmpTableDir).length);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, grantUserName, namespace, Permission.Action.READ);
        TEST_UTIL.getMiniHBaseCluster().shutdown();
        TEST_UTIL.restartHBaseCluster(1);
        TEST_UTIL.waitUntilNoRegionsInTransition();
        conf = TEST_UTIL.getConfiguration();
        admin = TEST_UTIL.getAdmin();
        helper = new SnapshotScannerHDFSAclHelper(conf, admin.getConnection());
        Path tmpNsDir = helper.getPathHelper().getTmpNsDir(namespace);
        Assert.assertTrue((boolean)FS.exists(tmpNsDir));
        Assert.assertEquals((long)0L, (long)FS.listStatus(tmpTableDir).length);
        TestHDFSAclHelper.createTableAndPut(TEST_UTIL, table);
        aclTable = TEST_UTIL.getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);
        this.snapshotAndWait(snapshot, table);
        TestHDFSAclHelper.canUserScanSnapshot(TEST_UTIL, grantUser, snapshot, 6);
        TestSnapshotScannerHDFSAclController.deleteTable(table);
        TestSnapshotScannerHDFSAclController.deleteTable(table2);
    }

    static void checkUserAclEntry(FileSystem fs, List<Path> paths, String user, boolean requireAccessAcl, boolean requireDefaultAcl) throws Exception {
        for (Path path : paths) {
            TestSnapshotScannerHDFSAclController.checkUserAclEntry(fs, path, user, requireAccessAcl, requireDefaultAcl);
        }
    }

    static void checkUserAclEntry(FileSystem fs, Path path, String userName, boolean requireAccessAcl, boolean requireDefaultAcl) throws IOException {
        boolean accessAclEntry = false;
        boolean defaultAclEntry = false;
        if (fs.exists(path)) {
            for (AclEntry aclEntry : fs.getAclStatus(path).getEntries()) {
                String user = aclEntry.getName();
                if (user == null || !user.equals(userName)) continue;
                if (aclEntry.getScope() == AclEntryScope.DEFAULT) {
                    defaultAclEntry = true;
                    continue;
                }
                if (aclEntry.getScope() != AclEntryScope.ACCESS) continue;
                accessAclEntry = true;
            }
        }
        String message = "require user: " + userName + ", path: " + path.toString() + " acl";
        Assert.assertEquals((String)message, (Object)requireAccessAcl, (Object)accessAclEntry);
        Assert.assertEquals((String)message, (Object)requireDefaultAcl, (Object)defaultAclEntry);
    }

    static void deleteTable(TableName tableName) {
        try {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        catch (IOException e) {
            LOG.warn("Failed to delete table: {}", (Object)tableName);
        }
    }
}

