/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.token.ClientTokenUtil;
import org.apache.hadoop.hbase.security.token.SecureTestCluster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SecurityTests.class, MediumTests.class})
public class TestGenerateDelegationToken
extends SecureTestCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestGenerateDelegationToken.class);
    @Parameterized.Parameter
    public String rpcClientImpl;

    @BeforeClass
    public static void setUp() throws Exception {
        SecureTestCluster.setUp();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());){
            Token token = ClientTokenUtil.obtainToken((Connection)conn);
            UserGroupInformation.getCurrentUser().addToken(token);
        }
    }

    @Parameterized.Parameters(name="{index}: rpcClientImpl={0}")
    public static Collection<Object> parameters() {
        return Arrays.asList(NettyRpcClient.class.getName());
    }

    @Before
    public void setUpBeforeMethod() {
        TEST_UTIL.getConfiguration().set("hbase.rpc.client.impl", this.rpcClientImpl);
    }

    @Test
    public void test() throws Exception {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             Table table = conn.getTable(TableName.META_TABLE_NAME);){
            CoprocessorRpcChannel rpcChannel = table.coprocessorService(HConstants.EMPTY_START_ROW);
            AuthenticationProtos.AuthenticationService.BlockingInterface service = AuthenticationProtos.AuthenticationService.newBlockingStub((BlockingRpcChannel)rpcChannel);
            AuthenticationProtos.WhoAmIResponse response = service.whoAmI(null, AuthenticationProtos.WhoAmIRequest.getDefaultInstance());
            Assert.assertEquals((Object)USERNAME, (Object)response.getUsername());
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.TOKEN.name(), (Object)response.getAuthMethod());
            try {
                service.getAuthenticationToken(null, AuthenticationProtos.GetAuthenticationTokenRequest.getDefaultInstance());
            }
            catch (ServiceException e) {
                IOException ioe = ProtobufUtil.getRemoteException((ServiceException)e);
                MatcherAssert.assertThat((Object)ioe, (Matcher)CoreMatchers.instanceOf(AccessDeniedException.class));
                MatcherAssert.assertThat((Object)ioe.getMessage(), (Matcher)CoreMatchers.containsString((String)"Token generation only allowed for Kerberos authenticated clients"));
            }
        }
    }
}

