/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.mapreduce.CopyTable;
import org.apache.hadoop.hbase.mapreduce.CopyTableTestBase;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotTTLExpiredException;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MapReduceTests.class, LargeTests.class})
public class TestCopyTable
extends CopyTableTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCopyTable.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Override
    protected Table createSourceTable(TableDescriptor desc) throws Exception {
        return TEST_UTIL.createTable(desc, (byte[][])null);
    }

    @Override
    protected Table createTargetTable(TableDescriptor desc) throws Exception {
        return TEST_UTIL.createTable(desc, (byte[][])null);
    }

    @Override
    protected void dropSourceTable(TableName tableName) throws Exception {
        TEST_UTIL.deleteTable(tableName);
    }

    @Override
    protected void dropTargetTable(TableName tableName) throws Exception {
        TEST_UTIL.deleteTable(tableName);
    }

    @Override
    protected String[] getPeerClusterOptions() throws Exception {
        return new String[0];
    }

    @Test
    public void testCopyTable() throws Exception {
        this.doCopyTableTest(TEST_UTIL.getConfiguration(), false);
    }

    @Test
    public void testCopyTableWithBulkload() throws Exception {
        this.doCopyTableTest(TEST_UTIL.getConfiguration(), true);
    }

    @Test
    public void testCopyTableWithMob() throws Exception {
        this.doCopyTableTestWithMob(TEST_UTIL.getConfiguration(), false);
    }

    @Test
    public void testCopyTableWithBulkloadWithMob() throws Exception {
        this.doCopyTableTestWithMob(TEST_UTIL.getConfiguration(), true);
    }

    @Test
    public void testStartStopRow() throws Exception {
        this.testStartStopRow(TEST_UTIL.getConfiguration());
    }

    @Test
    public void testRenameFamily() throws Exception {
        this.testRenameFamily(TEST_UTIL.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMainMethod() throws Exception {
        String[] emptyArgs = new String[]{"-h"};
        PrintStream oldWriter = System.err;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        PrintStream writer = new PrintStream(data);
        System.setErr(writer);
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager((SecurityManager)newSecurityManager);
        try {
            CopyTable.main((String[])emptyArgs);
            Assert.fail((String)"should be exit");
        }
        catch (SecurityException e) {
            Assert.assertEquals((long)1L, (long)newSecurityManager.getExitCode());
        }
        finally {
            System.setErr(oldWriter);
            System.setSecurityManager(SECURITY_MANAGER);
        }
        Assert.assertTrue((boolean)data.toString().contains("rs.class"));
        Assert.assertTrue((boolean)data.toString().contains("Usage:"));
    }

    private Table createTable(TableName tableName, byte[] family, boolean isMob) throws IOException {
        if (isMob) {
            ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])family).setMobEnabled(true).setMobThreshold(1L).build();
            TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(cfd).build();
            return TEST_UTIL.createTable(desc, (byte[][])null);
        }
        return TEST_UTIL.createTable(tableName, family);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCopyTableBySnapshot(String tablePrefix, boolean bulkLoad, boolean isMob) throws Exception {
        TableName table1 = TableName.valueOf((String)(tablePrefix + 1));
        TableName table2 = TableName.valueOf((String)(tablePrefix + 2));
        String snapshot = tablePrefix + "_snapshot";
        try (Table t1 = this.createTable(table1, FAMILY_A, isMob);
             Table t2 = this.createTable(table2, FAMILY_A, isMob);){
            this.loadData(t1, FAMILY_A, Bytes.toBytes((String)"qualifier"));
            TEST_UTIL.getAdmin().snapshot(snapshot, table1);
            boolean success = bulkLoad ? this.runCopy(TEST_UTIL.getConfiguration(), new String[]{"--snapshot", "--new.name=" + table2, "--bulkload", snapshot}) : this.runCopy(TEST_UTIL.getConfiguration(), new String[]{"--snapshot", "--new.name=" + table2, snapshot});
            Assert.assertTrue((boolean)success);
            this.verifyRows(t2, FAMILY_A, Bytes.toBytes((String)"qualifier"));
        }
        finally {
            TEST_UTIL.getAdmin().deleteSnapshot(snapshot);
            TEST_UTIL.deleteTable(table1);
            TEST_UTIL.deleteTable(table2);
        }
    }

    @Test
    public void testLoadingSnapshotToTable() throws Exception {
        this.testCopyTableBySnapshot("testLoadingSnapshotToTable", false, false);
    }

    @Test
    public void testLoadingTtlExpiredSnapshotToTable() throws Exception {
        String tablePrefix = "testLoadingExpiredSnapshotToTable";
        TableName table1 = TableName.valueOf((String)(tablePrefix + 1));
        TableName table2 = TableName.valueOf((String)(tablePrefix + 2));
        Table t1 = this.createTable(table1, FAMILY_A, false);
        this.createTable(table2, FAMILY_A, false);
        this.loadData(t1, FAMILY_A, Bytes.toBytes((String)"qualifier"));
        String snapshot = tablePrefix + "_snapshot";
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("TTL", 10);
        SnapshotDescription snapshotDescription = new SnapshotDescription(snapshot, table1, SnapshotType.FLUSH, null, EnvironmentEdgeManager.currentTime(), -1, properties);
        TEST_UTIL.getAdmin().snapshot(snapshotDescription);
        boolean isExist = TEST_UTIL.getAdmin().listSnapshots().stream().anyMatch(ele -> snapshot.equals(ele.getName()));
        Assert.assertTrue((boolean)isExist);
        for (int retry = 6; !SnapshotDescriptionUtils.isExpiredSnapshot((long)snapshotDescription.getTtl(), (long)snapshotDescription.getCreationTime(), (long)EnvironmentEdgeManager.currentTime()) && retry > 0; --retry) {
            Thread.sleep(10000L);
        }
        boolean isExpiredSnapshot = SnapshotDescriptionUtils.isExpiredSnapshot((long)snapshotDescription.getTtl(), (long)snapshotDescription.getCreationTime(), (long)EnvironmentEdgeManager.currentTime());
        Assert.assertTrue((boolean)isExpiredSnapshot);
        String[] args = new String[]{"--snapshot", "--new.name=" + table2, "--bulkload", snapshot};
        Assert.assertThrows(SnapshotTTLExpiredException.class, () -> this.runCopy(TEST_UTIL.getConfiguration(), args));
    }

    @Test
    public void tsetLoadingSnapshotToMobTable() throws Exception {
        this.testCopyTableBySnapshot("testLoadingSnapshotToMobTable", false, true);
    }

    @Test
    public void testLoadingSnapshotAndBulkLoadToTable() throws Exception {
        this.testCopyTableBySnapshot("testLoadingSnapshotAndBulkLoadToTable", true, false);
    }

    @Test
    public void testLoadingSnapshotAndBulkLoadToMobTable() throws Exception {
        this.testCopyTableBySnapshot("testLoadingSnapshotAndBulkLoadToMobTable", true, true);
    }

    @Test
    public void testLoadingSnapshotWithoutSnapshotName() throws Exception {
        Assert.assertFalse((boolean)this.runCopy(TEST_UTIL.getConfiguration(), new String[]{"--snapshot"}));
    }

    @Test
    public void testLoadingSnapshotWithoutDestTable() throws Exception {
        Assert.assertFalse((boolean)this.runCopy(TEST_UTIL.getConfiguration(), new String[]{"--snapshot", "sourceSnapshotName"}));
    }
}

